#include <stdio.h>

#include "connection.h"

void main(char **args) {
    Connection *connection;
    Result *result;
    
    try {
	printf("Connecting...\n");
#if defined(HAS_MSQL)
	connection = new Connection("athens.imaginary.com", "db_test");
#elif defined(HAS_MYSQL)
	connection = new Connection("athens.imaginary.com", "db_test", 0, 0);
#else
	#error No database linked.
#endif
	printf("Issuing query...\n");
	result = connection->Query("SELECT test_id, test_val FROM test");
	printf("Results:\n");
	printf("Rows: %d\n", result->GetRowCount());
	while( result->Next() ) {
	    Row *row = result->GetCurrentRow();

	    printf("id: %s, val: %s\n", row->GetField(1), row->GetField(2));
	    row->Close();
	    delete row;
	}
	result->Close();
	delete result;
	connection->Close();
	delete connection;
	printf("Done.\n");
    }
    catch( char *err ) {
	printf("Error: %s\n", err);
	exit(-1);
    }
}
