#include <malloc.h>

#include "row.h"

Row::Row(MYSQL_RES *res, MYSQL_ROW row) {
    fields = row;
    result = res;
}

Row::~Row() {
    if( fields ) {
	Close();
    }
}

int Row::GetFieldCount() {
    if( !fields ) {
	throw "Row closed.";
    }
    return mysql_num_fields(result);
}

char *Row::GetField(int field) {
    if( !fields ) {
	throw "Row closed.";
    }
    if( field < 1 || field > GetFieldCount() ) {
	throw "Field index out of bounds.";
    }
    return fields[field-1];
}

void Row::Close() {
    if( !fields ) {
	throw "Row closed.";
    }
    fields = (MYSQL_ROW)NULL;
    result = (MYSQL_RES *)NULL;
}
