#include "result.h"

Result::Result(MYSQL_RES *r) {
    result = r;
    row_count = -1; // only get it if it is requested
}

Result::~Result() {
    if( result ) {
	Close();
    }
}

void Result::Close() {
    if( !result ) {
	return;
    }
    mysql_free_result(result);
    result = (MYSQL_RES *)NULL;
}

Row *Result::GetCurrentRow() {
    if( !result ) {
	throw "Result set closed.";
    }
    return current_row;
}

int Result::GetRowCount() {
    if( !result ) {
	throw "Result set closed.";
    }
    if( row_count > -1 ) {
	return row_count;
    }
    else {
	row_count = mysql_num_rows(result);
	return row_count;
    }
}

int Result::Next() {
    MYSQL_ROW row;
    
    if( !result ) {
	throw "Result set closed.";
    }
    row = mysql_fetch_row(result);
    if( !row ) {
	current_row = (Row *)NULL;
	return 0;
    }
    else {
	current_row = new Row(result, row);
	return 1;
    }
}
	
