#include "result.h"

Result::Result(m_result *r) {
    result = r;
    row_count = -1; // only get it if it is requested
}

Result::~Result() {
    if( result != NULL ) {
	Close();
    }
}

void Result::Close() {
    if( result == (m_result *)NULL ) {
	return;
    }
    msqlFreeResult(result);
    result = (m_result *)NULL;
}

Row *Result::GetCurrentRow() {
    if( result == (m_result *)NULL ) {
	throw "Result set closed.";
    }
    return current_row;
}

int Result::GetRowCount() {
    if( result == (m_result *)NULL ) {
	throw "Result set closed.";
    }
    if( row_count > -1 ) {
	return row_count;
    }
    else {
	row_count = msqlNumRows(result);
	return row_count;
    }
}

int Result::Next() {
    m_row row;
    
    if( result == (m_result *)NULL ) {
	throw "Result set closed.";
    }
    row = msqlFetchRow(result);
    if( row == (m_row)NULL ) {
	current_row = (Row *)NULL;
	return 0;
    }
    else {
	current_row = new Row(result, row);
	return 1;
    }
}
	
