#include "connection.h"

Connection::Connection(char *host, char *db) {
    int state;
    
    connection = msqlConnect(host);
    if( connection < 0 ) {
	connection = -1;
	throw msqlErrMsg;
    }
    state = msqlSelectDB(connection, db);
    if( state < 0 ) {
	Close();
	throw msqlErrMsg;
    }
}

Connection::~Connection() {
    if( connection > -1 ) {
	Close();
    }
}

void Connection::Close() {
    if( connection < 0 ) {
	return;
    }
    msqlClose(connection);
    connection = -1;
}

Result *Connection::Query(char *sql) {
    int state;

    // ³Ƥʤ硢٤Ȥϲʤ
    if( connection < 0 ) {
	throw "Not connected.";
    }

    // ¹Ԥ롣
    state = msqlQuery(connection, sql);

    // 顼ȯ
    if( state < 0 ) {
	throw msqlErrMsg;
    }

    // ΤResult󥹥󥹤֤
    return new Result(msqlStoreResult());
}
