#include "connection.h"

Connection::Connection(char *host, char *db) {
#if defined(HAS_MSQL)
    connection = -1;
#elif defined(HAS_MYSQL)
    connection = (MYSQL *)NULL;
#else
    #error No database linked.
#endif    
    Connect(host, db, (char *)NULL, (char *)NULL);
}

Connection::Connection(char *host, char *db, char *uid, char *pw) {
#if defined(HAS_MSQL)
    connection = -1;
#elif defined(HAS_MYSQL)
    connection = (MYSQL *)NULL;
#else
    #error No database linked.
#endif    
    Connect(host, db, uid, pw);
}

Connection::~Connection() {
    if( IsConnected() ) {
	Close();
    }
}

void Connection::Close() {
    if( !IsConnected() ) {
	return;
    }
#if defined(HAS_MSQL)    
    msqlClose(connection);
    connection = -1;
#elif defined(HAS_MYSQL)    
    mysql_close(connection);
    connection = (MYSQL *)NULL;
#else
    #error No database linked.
#endif    
}

void Connection::Connect(char *host, char *db, char *uid, char *pw) {
    int state;

    if( IsConnected() ) {
	throw "Connection has already been established.";
    }
#if defined(HAS_MSQL)
    connection = msqlConnect(host);
#elif defined (HAS_MYSQL)
    connection = mysql_connect(&mysql, host, uid, pw);
#else
	#error No database linked.
#endif	
    if( !IsConnected() ) {
	throw GetError();
    }
#if defined(HAS_MSQL)
    state = msqlSelectDB(connection, db);
#elif defined (HAS_MYSQL)
    state = mysql_select_db(connection, db);
#else
    #error No database linked.
#endif    
    if( state < 0 ) {
	throw GetError();
    }
}

int Connection::GetAffectedRows() {
    return affected_rows;
}

char *Connection::GetError() {
#if defined(HAS_MSQL)
    return msqlErrMsg;
#elif defined(HAS_MYSQL)
    if( IsConnected() ) {
	return mysql_error(connection);
    }
    else {
	return mysql_error(&mysql);
    }
#else
    #error No database linked.
#endif
}

int Connection::IsConnected() {
#if defined(HAS_MSQL)
    return !(connection < 0);
#elif defined(HAS_MYSQL)
    return !(!connection);
#else
    #error No database linked.
#endif	
}

Result *Connection::Query(char *sql) {
    T_RESULT *res;
    int state;

    // ³Ƥʤ硢٤Ȥϲʤ
    if( !IsConnected() ) {
	throw "Not connected.";
    }

    // ¹Ԥ롣
#if defined(HAS_MSQL)    
    state = msqlQuery(connection, sql);
#elif defined(HAS_MYSQL)    
    state = mysql_query(connection, sql);
#else
    #error No database linked.
#endif

    // 顼ȯ
    if( state < 0 ) {
	throw GetError();
    }

    // ̤С̤롣
#if defined(HAS_MSQL)
    res = msqlStoreResult();
#elif defined(HAS_MYSQL)
    res = mysql_store_result(connection);
#else
    #error No database linked.
#endif

    // ̤nullξϡåץǡȤǤ뤫ޤϥ顼ȯƤ롣
    // աmSQLǤmsqlStoreResult()ǥ顼ʤ
    if( res == (T_RESULT *)NULL ) {
	// affected_rowsmsqlQuery()ͤꤹǤ롣
#if defined(HAS_MSQL)
	affected_rows = state;
#elif defined(HAS_MYSQL)
	// MySQL ϰѤä顼åΥᥫ˥ġ
	// field_count != 0Ȥϡ顼ȯȤ̣롣
	int field_count = mysql_num_fields(connection);

	if( field_count != 0 ) {
	    throw GetError();
	}
	else {
	    // affected_rowsǼ롣
	    affected_rows = mysql_affected_rows(connection);
	}
#else
	#error No database linked.
#endif
	// åץǡȤΤNULL֤
	return (Result *)NULL;
    }
    // ΤResult󥹥󥹤֤
    return new Result(res);
}
