#!/usr/bin/perl -w

# This is the complete version of the script covered in part on page 162 of the book.

use strict;
require my_end;

use CGI qw(:standard);
my $output = new CGI;
use_named_parameters(1);

# Use the DBI module.
use DBI;
# DBI::connect() uses the format 'DBI:driver:database', in our case we 
# are using the mSQL driver and accessing the 'teach' database.
my $dbh = DBI->connect('DBI:mSQL:teach');

&default if not param('action');
for (param('action')) {
   $_ eq 'add' and do { &add; last; };
   $_ eq 'add2' and do { &add2; last; };
   $_ eq 'add3' and do { &add3; last; };
   &default;
}

###
#Default
###
sub default {
   print header, start_html('title'=>'Tests Main Page', 'BGCOLOR'=>'white');
   print <<HTML;
<H1>Tests</h1>
<FORM ACTION="test.cgi" METHOD=POST>
<p>
Choose action <SELECT NAME="action">
<OPTION VALUE="add">Add a Test
</select> for subject <SELECT NAME="subjects">
<OPTION VALUE="all">All
HTML
   # DBI::prepare() sets up a query to be sent to the database. It
   # does not automatically execute the query, because it provides
   # functionality to set up a partial query and fill in the values
   # at execute time. This is handy for executing lots of similar
   # queries.
   my $out = $dbh->prepare("select * from subjects order by name");
   # DBI::execute() actually performs the query.
   $out->execute;
   # DBI::fetchrow_hashref is analogous to Msql::fetchhash except
   # that it returns a reference to a hash rather than the hash itself.
   while(my $keysref = $out->fetchrow_hashref) {
      my %keys = %$keysref;
      print qq%<OPTION VALUE="$keys{'id'}">$keys{'name'}\n%;
   }
   print <<HTML;
</select> <INPUT TYPE=SUBMIT VALUE="GO">
</form></body></html>
HTML
}

###
#Add
###
sub add {

   my $subject = "";
   $subject = param('subject') if (param('subjects'));
   $subject = "" if $subject eq 'all';

   print header, start_html('title'=>'Create a New Test',
      'BGCOLOR'=>'white');
   print <<HTML;
<H1>Create a New Test</h1>
<FORM ACTION="test.cgi" METHOD=POST>
<INPUT TYPE=HIDDEN NAME="action" VALUE="add2">
Subject: 
HTML
   my @ids = ();
   my %subjects = ();
   my $out2 = $dbh->prepare("select id,name from subjects order by name");
   $out2->execute;
   # DBI::fetchrow_array() is exactly analogous to Msql::fetchrow()
   while(my($id,$subject)=$out2->fetchrow_array) {
      push(@ids,$id);
      $subjects{"$id"} = $subject;
   }
   print popup_menu('name'=>'subjects',
      'values'=>[@ids],
      'default'=>$subject,
      'labels'=>\%subjects);
   print <<HTML;
<br>
Number of Questions: <INPUT NAME="num" SIZE=5><br>
A name other identifier (such as a date) for the test: 
 <INPUT NAME="name" SIZE=20>
<p>
<INPUT TYPE=SUBMIT VALUE=" Next Page ">
 <INPUT TYPE=RESET>
</form></body></html>
HTML

}

###
#Add - Stage 2
###
sub add2 {
   &end('A subject is required') if not param('subjects');
   &end('You must enter a number of question') if not param('num');
   my $subject = param('subjects');
   my $num = param('num');
   my $name = "";
   $name = param('name') if param('name');

   my $out = $dbh->prepare("select name from subjects where id=$subject");
   $out->execute;
   my ($subname) = $out->fetchrow_array;

   print header, start_html('title'=>"Creating test for $subname",
      'BGCOLOR'=>'white');
   print <<HTML;
<H1>Creating test for $subname</h1>
<h2>$name</h2>
<p>
<FORM ACTION="test.cgi" METHOD=POST>
<INPUT TYPE=HIDDEN NAME="action" VALUE="add3">
<INPUT TYPE=HIDDEN NAME="subjects" VALUE="$subject">
<INPUT TYPE=HIDDEN NAME="num" VALUE="$num">
<INPUT TYPE=HIDDEN NAME="name" VALUE="$name">
Enter the point value for each of the questions. The points need not
add up to 100.
<p>
HTML
   for (1..$num) {
      print qq%$_: <INPUT NAME="q$_" SIZE=3> %;
      if (not $_ % 5) { print "<br>\n"; }
   }
   print <<HTML;
<p>
Enter the text of the test:<br>
<TEXTAREA NAME="test" ROWS=20 COLS=60>
</textarea>
<p>
<INPUT TYPE=SUBMIT VALUE="Enter Test">
 <INPUT TYPE=RESET>
</form></body></html>
HTML
}

###
#Add - Stage 3
###
sub add3 {
   &end('A subject is required') if not param('subjects');
   &end('You must enter a number of question') if not param('num');
   my $subject = param('subjects');
   my $num = param('num');

   my $name = "";
   $name = param('name') if param('name');
   
   my $out = $dbh->prepare("select _seq from tests");
   $out->execute;
   my ($id) = $out->fetchrow_array;

   my $qname;
   ($qname = $name) =~ s/'/\\'/g;
   my $q1 = "insert into tests (id, name, subject, num) values (
      $id, '$qname', $subject, $num)";

   my $in = $dbh->prepare($q1);
   $in->execute;

   my $query = "create table t$id (
      id INT NOT NULL,
   ";

   my $def = "insert into t$id values ( 0, ";

   my $total = 0;
   my @qs = grep(/^q\d+$/,param);
   foreach (@qs) {
      $query .= $_ . " INT,\n";
      my $value = 0;
      $value = param($_) if param($_);
      $def .= "$value, ";
      $total += $value;
   }
   $query .= "total INT\n)";
   $def .= "$total)";

   my $in2 = $dbh->prepare($query);
   $in2->execute;
   my $in3 = $dbh->prepare($def);
   $in3->execute;

   # Note that we store the tests in separate files. This is useful when
   # dealing with mSQL because of its lack of BLOBs. In MySQL, we could
   # just stick the entire test into a BLOB.
   open(TEST,">teach/tests/$id") or die("A: $id $!");
   print TEST param('test'), "\n";
   close TEST;

   print header, start_html('title'=>'Test Created', 'BGCOLOR'=>'white');
   print <<HTML;
<H1>Test Created</h1>
<p>
The test has been created.
<p>
<A HREF=".">Go</a> to the Teacher's Aide home page.<br>
<A HREF="test.cgi">Go</a> to the Test main page.<br>
<A HREF="test.cgi?action=add">Add</a> another test.
</body></html>
HTML
}

