#!/usr/bin/perl -w

# This is the complete version of the script covered in part on page 175 of the book.

use strict;
require my_end;

use CGI qw(:standard);
my $output = new CGI;
use_named_parameters(1);

use Msql;
my $dbh = Msql->connect;
$dbh->selectdb("teach");

&default if not param('action');
for (param('action')) {
   $_ eq 'search' and do { &search; last; };
   $_ eq 'search2' and do { &search2; last; };
   $_ eq 'view' and do { &view; last; };
   $_ eq 'add' and do { &add; last; };
   $_ eq 'add2' and do { &add2; last; };
   $_ eq 'change' and do { &change; last; };
   $_ eq 'change2' and do { &change2; last; };
   $_ eq 'change3' and do { &change3; last; };
   $_ eq 'delete' and do { &delete; last; };
   $_ eq 'delete2' and do { &delete2; last; };
   &default;
}

###
#Default
###
sub default {
   print header, start_html('title'=>'Students Home Page',
      'BGCOLOR'=>'white');
   print <<HTML;
<FORM ACTION="students.cgi" METHOD=POST>
<H1>Students</h1>
<SELECT NAME="action">
<OPTION VALUE="search">Search for a Student
<OPTION VALUE="add">Add a Student
<OPTION VALUE="change">Change a Student
<OPTION VALUE="delete">Delete a Student
</select>
 <INPUT TYPE=SUBMIT VALUE=" Go ">
</form></body></html>
HTML

}

###
#Add
###
sub add {
   print header, start_html('title'=>'Add a Student',
      'BGCOLOR'=>'white');
   &print_form('add2','Add a Student',0);
   print <<HTML;
<p>
<INPUT TYPE=SUBMIT VALUE=" Add Student ">
 <INPUT TYPE=RESET>
</form></body></html>
HTML
}

###
#Add - Stage 2
###
sub add2 {
   my (%fields);
   
   my $age = 0;
   my $sex = 0;

   foreach ('first', 'middle', 'last', 'ext', 'address', 'city',
      'state', 'zip', 'phone') {
      if (param($_)) { $fields{$_} = $dbh->quote(param($_)); }
      else { $fields{$_} = "''"; }
   }
   $age = param('age') if param('age');
   $sex = param('sex') if param('sex');
   
   my $subjects = "':";
   $subjects .= join(":",param('subjects'));
   $subjects .= ":" unless $subjects eq "':";
   $subjects .= "'";

   # Note that a null value is used for the 'id' field. This will
   # cause the database to auto_increment the value.
   my $query = "insert into students (id, first, middle, last,
      ext, subjects, age, sex, address, city, state, zip, phone)
      values ('', $fields{'first'}, $fields{'middle'},
      $fields{'last'}, $fields{'ext'}, $subjects, $age, $sex,
      $fields{'address'}, $fields{'city'}, $fields{'state'},
      $fields{'zip'}, $fields{'phone'})";

   $dbh->query($query);

   print header, start_html('title'=>'Student Added','BGCOLOR'=>'white');

   print <<HTML;
<H1>Student Added</h1>
<p>The student has been added to the database.
<p>
<A HREF="students.cgi">Go</a> to the Students Home Page.<br>
<A HREF="students.cgi?action=add">Add</a> another student.<br>
<A HREF=".">Go</a> to the Teacher's Aide Home Page.
<p>
</body></html>
HTML

}

###
#Search
###
sub search {
   print header, start_html('title'=>'Student Search',
      'BGCOLOR'=>'white');
   &print_form('search2','Student Search',1);
   print <<HTML;
<p>
<INPUT TYPE=HIDDEN NAME="subaction" VALUE="view">
<INPUT TYPE=SUBMIT VALUE=" Search for Students ">
 <INPUT TYPE=SUBMIT NAME="all" VALUE=" View all Students ">
 <INPUT TYPE=RESET>
</form></body></html>
HTML

}

###
#Search 2
###
sub search2 {
   my $out = $dbh->query(&make_search_query);
   my $hits = $out->numrows;
   my $subaction = "view";
   $subaction = param('subaction') if param('subaction');
   print header, start_html('title'=>'Student Search Result',
      'BGCOLOR'=>'white');

   if (not $hits) {
      print <<HTML;
<H1>No students found</h1>
<p>
No students matched your criteria.
HTML
   } else {
      print <<HTML;
<H1>$hits students found</h1>
<p>
<UL>
HTML
      while(my(%fields)=$out->fetchhash) {
         print qq%<LI>
<A HREF="students.cgi?action=$subaction&id=$fields{'id'}">$fields{'first'}
 $fields{'middle'} $fields{'last'}%;
         print ", $fields{'ext'}" if $fields{'ext'};
         print "\n</a>";
      }
   }
   print <<HTML;
</ul>
<p>
<A HREF="students.cgi?action=search">Search</a> again.
</body></html>
HTML
}

###
#Change
###
sub change {
   print header, start_html('title'=>'Student Change Search',
      'BGCOLOR'=>'white');
   &print_form('search2','Search for a Student to Change',1);
   print <<HTML;
<p>
<INPUT TYPE=HIDDEN NAME="subaction" VALUE="change2">
<INPUT TYPE=SUBMIT VALUE=" Search for Students ">
 <INPUT TYPE=SUBMIT NAME="all" VALUE=" View all Students ">
 <INPUT TYPE=RESET>
</form></body></html>
HTML
}

###
#Change - Stage 2
###
sub change2 {
   if (not param('id')) { &end("ID is required."); }
   my $id = param('id');
   my $out = $dbh->query("select * from students where id=$id");
   
   if (not $out->numrows) {
      &end("There is no student with that ID.");
   }

   my($did,$first,$middle,$last,$ext,$subjects,$age,$sex,$address,
      $city,$state,$zip,$phone) = $out->fetchrow;

   my @subjects = split(/:/,$subjects);
   shift @subjects;
   my $name = "$first $middle $last";
   if ($ext) { $name .= ", $ext"; }

   print header, start_html('title'=>"$name",'BGCOLOR'=>'white');
   print <<HTML;
<H1>$name</h1>
<p>
<FORM ACTION="students.cgi" METHOD=POST>
<INPUT TYPE=HIDDEN NAME="action" VALUE="change3">
<INPUT TYPE=HIDDEN NAME="id" VALUE="$id">
First: <INPUT NAME="first" VALUE="$first" SIZE=20>
 Middle: <INPUT NAME="middle" VALUE="$middle" SIZE=10>
 Last: <INPUT NAME="last" VALUE="$last" SIZE=20>
 Jr./III/etc.: <INPUT NAME="ext" VALUE="$ext" SIZE=5>
<br>
Address: <INPUT NAME="address" VALUE="$address" SIZE=40><br>
City: <INPUT NAME="city" VALUE="$city" SIZE=20> 
 State: <INPUT NAME="state" VALUE="$state" SIZE=5>
 ZIP: <INPUT NAME="zip" VALUE="$zip" SIZE=10><br>
Phone: <INPUT NAME="phone" VALUE="$phone" SIZE=15><br>
Age: <INPUT NAME="age" VALUE="$age" SIZE=5> Sex: 
HTML
   my %sexes = ( '1' => 'Male',
      '2' => 'Female'
   );
   print popup_menu('name'=>'sex',
      'values'=>['1','2'],
      'default'=>"$sex",
      'labels'=>\%sexes);
   print <<HTML;
<p>
Enrolled in:<br>
HTML
   my @ids = ();
   my %subjects = ();
   my $out2 = $dbh->query("select id,name from subjects order by name");
   while(my($id,$subject)=$out2->fetchrow) { 
      push(@ids,$id); 
      $subjects{"$id"} = $subject;
   }
   print scrolling_list('name'=>'subjects',
      'values'=>[@ids],
      'default'=>[@subjects],
      'size'=>5,
      'multiple'=>'true',
      'labels'=>\%subjects);
   print <<HTML;
<p>
<INPUT TYPE=SUBMIT VALUE=" Change Student ">
 <INPUT TYPE=SUBMIT NAME="delete" VALUE=" Delete Student ">
 <INPUT TYPE=RESET>
</form></body></html>
HTML
}

###
#Change - Stage 3
###
sub change3 {
   if (not param('id')) { &end("ID required"); }
   my $id = param('id');

   if (param('delete')) { &delete2($id); }
   else {
      my $query = "update students set ";
      my @query = ();
      foreach ('first', 'middle', 'last', 'ext', 'address', 'city',
         'state', 'zip', 'phone') {
         if (param($_)) { push(@query,"$_ = ". 
            $dbh->quote(param($_))); }
      }
      push(@query,"age=".param('age')) if param('age');
      push(@query,"sex=".param('sex')) if param('sex');
   
      my $subjects = "':";
      $subjects .= join(":",param('subjects'));
      $subjects .= ":" unless $subjects eq "':";
      $subjects .= "'";
      push(@query,"subjects=$subjects");

      $query .= join(", ",@query) . " where id=$id";
      $dbh->query($query);

      print header, start_html('title'=>'Student Changed',
      'BGCOLOR'=>'white');
      print <<HTML;
<H1>Student Change</h1>
The student has been changed.   
<p>
<A HREF="students.cgi">Go</a> to the Students Home Page.<br>
<A HREF="students.cgi?action=change">Change</a> another student.<br>
<A HREF=".">Go</a> to the Teacher's Aide Home Page.
</body></html>
HTML
   }
}

###
#Delete
###
sub delete {
   print header, start_html('title'=>'Student Delete Search',
      'BGCOLOR'=>'white');
   &print_form('search2','Search for a Student to Delete',1);
   print <<HTML;
<p>
<INPUT TYPE=HIDDEN NAME="subaction" VALUE="delete2">
<INPUT TYPE=SUBMIT VALUE=" Search for Students ">
 <INPUT TYPE=SUBMIT NAME="all" VALUE=" View all Students ">
 <INPUT TYPE=RESET>
</form></body></html>
HTML
}

###
#Delete - Stage 2
###
sub delete2 {
   my ($id);
   if (@_) { $id = shift; }
   elsif (not param('id')) { &end("ID required"); }
   else { $id = param('id'); }

   $dbh->query("delete from students where id=$id");

   print header, start_html('title'=>'Student Deleted',
      'BGCOLOR'=>'white');
   print <<HTML;
<H1>Student Deleted</h1>
The student has been delete from the database.
<p>
<A HREF="students.cgi">Go</a> to the Students Home Page.<br>
<A HREF="students.cgi?action=delete">Delete</a> another student.<br>
<A HREF=".">Go</a> to the Teacher's Aide Home Page.
</body></html>
HTML
}

###
#View
###
sub view {
   my @sex = ('','Male','Female');

   if (not param('id')) { &end("ID is required"); }
   my $id = param('id');

   my $out = $dbh->query("select * from students where id=$id");

   if (not $out->numrows) {
      &end("There is no student with that ID.");
   }

   my($did,$first,$middle,$last,$ext,$subjects,$age,$sex,$address,
      $city,$state,$zip,$phone) = $out->fetchrow;

   my $name = "$first $middle $last";
   if ($ext) { $name .= ", $ext"; }

   print header, start_html('title'=>"$name",'BGCOLOR'=>'white');

   print <<HTML;
<H1>$name</h1>
<p>
$address<br>
$city, $state, $zip<br>
$phone<br>      
Age: $age Sex: $sex[$sex]
<p>
<A HREF="report.cgi?id=$id&subject=all">View general report card</a>
<p>
Enrolled Subjects (choose to view report):<br>
<UL>
HTML
   my @subjects = split(/:/,$subjects);
   shift @subjects;
   foreach (@subjects) {
      my $out = $dbh->query("select name from subjects where id=$_");
      my ($name) = $out->fetchrow;
      print <<HTML;
<LI><A HREF="report.cgi?id=$id&subject=$_">$name</a>
HTML
   }
   print <<HTML;
</ul>
</body></html>
HTML
}

sub make_search_query {
   my $bool = param('bool');

   my $query = "select id, first, middle, last, ext from students";
   my $query2 = " where ";

   if (not param('all')) {
      my @query = ();
      foreach ('first', 'middle', 'last', 'address', 'city',
         'state', 'zip', 'phone') {
         if (param($_)) { push(@query,"$_ clike '%".
            param($_) . "%'"); }
      }

      push(@query,"age = ".param('age')) if param('age');
      push(@query,"sex = ".param('sex')) if param('sex');

      if (param('subjects')) {
         foreach (param('subjects')) {
            push(@query,"subjects like '%:$_:%'");
         }
      }
      if (not @query) { return $query; }
      $query2 .= join(" $bool ", @query);
      $query .= $query2;
   }
   return $query;
}


sub print_subjects {
   my $modifier = "";
   $modifier = shift if @_;
   print qq%<SELECT NAME="subjects" $modifier>\n%;
   my $out = $dbh->query("select * from subjects order by name");
   while(my(%keys)=$out->fetchhash) {
      print qq%<OPTION VALUE="$keys{'id'}">$keys{'name'}\n%;
   }
   print "</select>\n";

}

sub print_form {
   my ($action,$message,$any) = @_;

   print <<HTML;
<FORM METHOD=post ACTION="students.cgi">
<INPUT TYPE=HIDDEN NAME="action" VALUE="$action">
<H1>$message</h1>
HTML
   if ($any) {
      print <<HTML;
<p>Search for <SELECT NAME="bool">
<OPTION VALUE="or">any
<OPTION VALUE="and">all
</select> of your choices.
HTML
   }
   print <<HTML;
<p>
First: <INPUT NAME="first" SIZE=20>
 Middle: <INPUT NAME="middle" SIZE=10>
 Last: <INPUT NAME="last" SIZE=20>
 Jr./III/etc.: <INPUT NAME="ext" SIZE=5>
<br>
Address: <INPUT NAME="address" SIZE=40><br>
City: <INPUT NAME="city" SIZE=20> 
 State: <INPUT NAME="state" SIZE=5>
 ZIP: <INPUT NAME="zip" SIZE=10><br>
Phone: <INPUT NAME="phone" SIZE=15><br>
Age: <INPUT NAME="age" SIZE=5> Sex: <SELECT NAME="sex">
HTML
   if ($any) {
   print <<HTML;
<OPTION VALUE="">Doesn't Matter
HTML
   }
print <<HTML;
<OPTION VALUE="1">Male
<OPTION VALUE="2">Female
</select><br>
<p>
Enrolled in:<br>
HTML
   &print_subjects("MULTIPLE SIZE=5");

}

