#include <stdio.h>
#include <cgic.h>
#include <time.h>
#include <msql.h>

#define PITCHER  0
#define CATCHER  1
#define FIRST_B  2
#define SECOND_B 3
#define THIRD_B  4
#define SHORT    5
#define OUTFIELD 6
#define DES_HIT  7

char *positions[] = {
    "P",
    "C",
    "B1",
    "B2",
    "B3",
    "SS",
    "OF",
    "DH"
};

char *choices[] = {
    "<",
    "=",
    ">"
};

char *bool_types[] = {
    "and",
    "or"
};


char fname[51];
char lname[51];
char club[51];
char year[10];
int G, W, L, R, ER, SO, BB, GS, CG, SHO, SV, AB, H, B2, B3, HR,
    RBI, SB;
double IP;

void Error(char *);
void CreateQuery(char *);
void HandleYear(char *, int, int);
void PerformQuery(char *);

int cgiMain() {
    char query[512] = "";

    cgiHeaderContentType("text/html");
    
    CreateQuery(query);

    fprintf(cgiOut, "<html><head>");
    fprintf(cgiOut, "<title>Baseball Database Change Search 
   Results</title>");
    fprintf(cgiOut, "<body>");
    PerformQuery(query);
    fprintf(cgiOut, "</body></html>\n");

    return 0;
}

void CreateQuery(char *query) {
    int positionsChosen[8];
    int result, invalid, i, choice, length, b_length, bool_type;
    char dummy[512];
    char positionString[256] = "";
    char yearString[50] = "";

    /* We need to select the 'id' and 'year' along with the names this time.
    We can also make things easier on us by adding an 'order by lname, 
    fname' to ensure that the names are returned in the correct order 
    */
    strcat(query,"Select id, fname, lname, year from baseball");
    result = cgiFormStringNoNewlines("all", dummy, 20);
    if (result = cgiFormSuccess) {
   strcat(query," order by lname, fname");
   return;
    }

    strcat(query," where");

    result = cgiFormSelectSingle("bool_type", bool_types, 2, &bool_type, 0);
    if ((result == cgiFormNotFound) || (result == cgiFormEmpty))
   Error("Invalid form");

    result = cgiFormStringNoNewlines("fname",fname,51);
    if (result == cgiFormTruncated)
   Error("Names cannot be longer than 50 characters.");

    result = cgiFormStringNoNewlines("lname",lname,51);
    if (result == cgiFormTruncated)
   Error("Names cannot be longer than 50 characters.");

    result = cgiFormStringNoNewlines("club",club,51);
    if (result == cgiFormTruncated)
   Error("Club names cannot be longer than 50 characters.");

    result = cgiFormCheckboxMultiple("position",positions,8,
   positionsChosen, &invalid);
    if (invalid)
   Error("Invalid form data was submitted");
    for (i = 0; i < 8; i++) {
   if (positionsChosen[i]) {
       sprintf(dummy," position like '%%%%%s%%%%' %s", 
      positions[i],  bool_types[bool_type]);
       strcat(positionString, dummy);
   }
    }

    result = cgiFormStringNoNewlines("year",year,10);
    if (result == cgiFormSuccess) {
   result = cgiFormSelectSingle("Gyear",choices,3,&choice,0);
   if ((result == cgiFormNotFound) || (result == cgiFormEmpty))
       Error("Invalid form");
   HandleYear(yearString, bool_type, choice);
    }

    result = cgiFormIntegerBounded("G",&G,0,999,0);
    if (result == cgiFormConstrained)
   Error("One of the numeric form values was either less
than zero or unreasonably large[AO1]: G");

    if (positionsChosen[PITCHER]) {
   result = cgiFormIntegerBounded("W",&W,0,99,0);
   if (result == cgiFormConstrained)
       Error("One of the numeric form values was either less
than zero or unreasonably large: W");
   result = cgiFormIntegerBounded("L",&L,0,99,0);
   if (result == cgiFormConstrained)
       Error("One of the numeric form values was either less
than zero or unreasonably largeunreasonably large: L");
   result = cgiFormDoubleBounded("IP",&IP,0.0,999.0,0.0);
   if (result == cgiFormConstrained)
       Error("One of the numeric form values was either less
than zero or unreasonably large: IP");
   result = cgiFormIntegerBounded("RP",&R,0,999,0);
   if (result == cgiFormConstrained)
       Error("One of the numeric form values was either less
than zero or unreasonably large: R");
   result = cgiFormIntegerBounded("ER",&ER,0,999,0);
   if (result == cgiFormConstrained)
       Error("One of the numeric form values was either less
than zero or unreasonably large: ER");
   result = cgiFormIntegerBounded("SOP",&SO,0,999,0);
   if (result == cgiFormConstrained)
       Error("One of the numeric form values was either less
than zero or unreasonably large: SO");
   result = cgiFormIntegerBounded("BBP",&BB,0,999,0);
   if (result == cgiFormConstrained)
       Error("One of the numeric form values was either less
than zero or unreasonably large: BB");
   result = cgiFormIntegerBounded("GS",&GS,0,99,0);
   if (result == cgiFormConstrained)
       Error("One of the numeric form values was either less
than zero or unreasonably large: GS");
   result = cgiFormIntegerBounded("CG",&CG,0,99,0);
   if (result == cgiFormConstrained)
       Error("One of the numeric form values was either less
than zero or unreasonably large: CG");
   result = cgiFormIntegerBounded("SHO",&SHO,0,99,0);
   if (result == cgiFormConstrained)
       Error("One of the numeric form values was either less
than zero or unreasonably large: SHO");
   result = cgiFormIntegerBounded("SV",&SV,0,99,0);
   if (result == cgiFormConstrained)
       Error("One of the numeric form values was either less
than zero or unreasonably large: SV");

   if (fname[0]) {
       sprintf(dummy," fname clike '%%%%%s%%%%' %s", fname, 
      bool_types[bool_type]);
       strcat(query,dummy);
   }
   if (lname[0]) {
       sprintf(dummy," lname clike '%%%%%s%%%%' %s", lname, 
      bool_types[bool_type]);
       strcat(query,dummy);
   }
   if (club[0]) {
       sprintf(dummy," club clike '%%%%%s%%%%' %s", club, 
      bool_types[bool_type]);
       strcat(query,dummy);
   }
   if (positionString[0]) {
       strcat(query,positionString);
   }
   if (yearString[0]) {
       strcat(query,yearString);
   }
   if (G) {
       result = cgiFormSelectSingle("GG",choices,3,&choice,0);
       if ((result == cgiFormNotFound) || 
      (result == cgiFormEmpty))
      Error("Invalid form");
       sprintf(dummy," G %s %d %s", choices[choice], G, 
      bool_types[bool_type]);
       strcat(query,dummy);
   }
   if (W) {
       result = cgiFormSelectSingle("GW",choices,3,&choice,0);
       if ((result == cgiFormNotFound) || 
      (result == cgiFormEmpty))
      Error("Invalid form");
       sprintf(dummy," W %s %d %s", choices[choice], W,  
      bool_types[bool_type]);
       strcat(query,dummy);
   }
   if (L) {
       result = cgiFormSelectSingle("GL",choices,3,&choice,0);
       if ((result == cgiFormNotFound) || 
      (result == cgiFormEmpty))
      Error("Invalid form");
       sprintf(dummy," L %s %d %s", choices[choice], L, 
         bool_types[bool_type]);
       strcat(query,dummy);
   }
   if (IP) {
       result = cgiFormSelectSingle("GIP",choices,3,&choice,0);
       if ((result == cgiFormNotFound) || 
      (result == cgiFormEmpty))
      Error("Invalid form");
       sprintf(dummy," IP %s %3.1f %s", choices[choice], 
      IP, bool_types[bool_type]);
       strcat(query,dummy);
   }
   if (R) {
       result = cgiFormSelectSingle("GRP",choices,3,&choice,0);
       if ((result == cgiFormNotFound) || 
      (result == cgiFormEmpty))
      Error("Invalid form");
       sprintf(dummy," R %s %d %s", choices[choice], R, 
         bool_types[bool_type]);
       strcat(query,dummy);
   }
   if (ER) {
       result = cgiFormSelectSingle("GER",choices,3,&choice,0);
       if ((result == cgiFormNotFound) || 
      (result == cgiFormEmpty))
      Error("Invalid form");
       sprintf(dummy," ER %s %d %s", choices[choice], 
      ER, bool_types[bool_type]);
       strcat(query,dummy);
   }
   if (SO) {
       result = cgiFormSelectSingle("GSOP",choices,3,&choice,
      0);
       if ((result == cgiFormNotFound) || 
      (result == cgiFormEmpty))
      Error("Invalid form");
       sprintf(dummy," SO %s %d %s", choices[choice], 
      SO, bool_types[bool_type]);
       strcat(query,dummy);
   }
   if (BB) {
       result = cgiFormSelectSingle("GBBP",choices,3,&choice,
      0);
       if ((result == cgiFormNotFound) || 
      (result == cgiFormEmpty))
      Error("Invalid form");
       sprintf(dummy," BB %s %d %s", choices[choice], 
      BB, bool_types[bool_type]);
       strcat(query,dummy);
   }
   if (GS) {
       result = cgiFormSelectSingle("GGS",choices,3,&choice,0);
       if ((result == cgiFormNotFound) || 
      (result == cgiFormEmpty))
      Error("Invalid form");
       sprintf(dummy," GS %s %d %s", choices[choice], 
      GS, bool_types[bool_type]);
       strcat(query,dummy);
   }
   if (CG) {
       result = cgiFormSelectSingle("GCG",choices,3,&choice,0);
       if ((result == cgiFormNotFound) || 
      (result == cgiFormEmpty))
      Error("Invalid form");
       sprintf(dummy," CG %s %d %s", choices[choice], 
      CG, bool_types[bool_type]);
       strcat(query,dummy);
   }
   if (SHO) {
       result = cgiFormSelectSingle("GSHO",choices,3,&choice,
      0);
       if ((result == cgiFormNotFound) || 
      (result == cgiFormEmpty))
      Error("Invalid form");
       sprintf(dummy," SHO %s %d %s", choices[choice], 
      SHO, bool_types[bool_type]);
       strcat(query,dummy);
   }
   if (SV) {
       result = cgiFormSelectSingle("GSV",choices,3,&choice,0);
       if ((result == cgiFormNotFound) || 
      (result == cgiFormEmpty))
      Error("Invalid form");
       sprintf(dummy," SV %s %d %s", choices[choice], 
      SV, bool_types[bool_type]);
       strcat(query,dummy);
   }

   length = strlen(query);
   for(i = length-2 ; i <= length ; i++) {
       query[i] = 0;
   }
    } else {
   result = cgiFormIntegerBounded("AB",&AB,0,999,0);
   if (result == cgiFormConstrained)
       Error("One of the numeric form values was either less
than zero or unreasonably large: AB");
   result = cgiFormIntegerBounded("RB",&R,0,999,0);
   if (result == cgiFormConstrained)
       Error("One of the numeric form values was either less
than zero or unreasonably large: R");
   result = cgiFormIntegerBounded("H",&H,0,999,0);
   if (result == cgiFormConstrained)
       Error("One of the numeric form values was either less
than zero or unreasonably large: H");
   result = cgiFormIntegerBounded("B2",&B2,0,999,0);
   if (result == cgiFormConstrained)
       Error("One of the numeric form values was either less
than zero or unreasonably large: 2B");
   result = cgiFormIntegerBounded("B3",&B3,0,99,0);
   if (result == cgiFormConstrained)
       Error("One of the numeric form values was either less
than zero or unreasonably large: 3B");
   result = cgiFormIntegerBounded("HR",&HR,0,99,0);
   if (result == cgiFormConstrained)
       Error("One of the numeric form values was either less
than zero or unreasonably large: HR");
   result = cgiFormIntegerBounded("RBI",&RBI,0,999,0);
   if (result == cgiFormConstrained)
       Error("One of the numeric form values was either less
than zero or unreasonably large: RBI");
   result = cgiFormIntegerBounded("SB",&SB,0,999,0);
   if (result == cgiFormConstrained)
       Error("One of the numeric form values was either less
than zero or unreasonably large: SB");
   result = cgiFormIntegerBounded("BBB",&BB,0,999,0);
   if (result == cgiFormConstrained)
       Error("One of the numeric form values was either less
than zero or unreasonably large: BB");
   result = cgiFormIntegerBounded("SOB",&SO,0,999,0);
   if (result == cgiFormConstrained)
       Error("One of the numeric form values was either less
than zero or unreasonably large: SO");

   if (fname[0]) {
       sprintf(dummy," fname clike '%%%%%s%%%%' %s", fname, 
      bool_types[bool_type]); 
       strcat(query,dummy);
   }
   if (lname[0]) {
       sprintf(dummy," lname clike '%%%%%s%%%%' %s", 
      lname, bool_types[bool_type]);
       strcat(query,dummy);
   }
   if (club[0]) {
       sprintf(dummy," club clike '%%%%%s%%%%' %s", 
      club, bool_types[bool_type]);
       strcat(query,dummy);
   }
   if (positionString[0]) {
       strcat(query,positionString);
   }
   if (yearString[0]) {
       strcat(query,yearString);
   }
   if (G) {
       result = cgiFormSelectSingle("GG",choices,3,&choice,0);
       if ((result == cgiFormNotFound) || 
      (result == cgiFormEmpty))
      Error("Invalid form");
       sprintf(dummy," G %s %d %s", choices[choice], G, 
      bool_types[bool_type]);
       strcat(query,dummy);
   }
   if (AB) {
       result = cgiFormSelectSingle("GAB",choices,3,&choice,0);
       if ((result == cgiFormNotFound) || 
      (result == cgiFormEmpty))
      Error("Invalid form");
       sprintf(dummy," AB %s %d %s", choices[choice], AB, 
      bool_types[bool_type]);
       strcat(query,dummy);
   }
   if (R) {
       result = cgiFormSelectSingle("GRB",choices,3,&choice,0);
       if ((result == cgiFormNotFound) || 
      (result == cgiFormEmpty))
      Error("Invalid form");
       sprintf(dummy," R %s %d %s", choices[choice], R, 
      bool_types[bool_type]);
       strcat(query,dummy);
   }
   if (H) {
       result = cgiFormSelectSingle("GH",choices,3,&choice,0);
       if ((result == cgiFormNotFound) || 
      (result == cgiFormEmpty))
      Error("Invalid form");
       sprintf(dummy," H %s %d %s", choices[choice], 
      H, bool_types[bool_type]);
       strcat(query,dummy);
   }
   if (B2) {
       result = cgiFormSelectSingle("GB2",choices,3,&choice,0);
       if ((result == cgiFormNotFound) || 
      (result == cgiFormEmpty))
      Error("Invalid form");
       sprintf(dummy," B2 %s %d %s", choices[choice], B2, 
      bool_types[bool_type]);
       strcat(query,dummy);
   }
   if (B3) {
       result = cgiFormSelectSingle("GB3",choices,3,&choice,0);
       if ((result == cgiFormNotFound) || 
      (result == cgiFormEmpty))
      Error("Invalid form");
       sprintf(dummy," B3 %s %d %s", choices[choice], 
      B3, bool_types[bool_type]);
       strcat(query,dummy);
   }
   if (HR) {
       result = cgiFormSelectSingle("GHR",choices,3,&choice,
      0);
       if ((result == cgiFormNotFound) || 
      (result == cgiFormEmpty))
      Error("Invalid form");
       sprintf(dummy," HR %s %d %s", choices[choice], 
      HR, bool_types[bool_type]);
       strcat(query,dummy);
   }
   if (RBI) {
       result = cgiFormSelectSingle("GRBI",choices,3,&choice,
      0);
       if ((result == cgiFormNotFound) || 
      (result == cgiFormEmpty))
      Error("Invalid form");
       sprintf(dummy," RBI %s %d %s", choices[choice], 
      RBI, bool_types[bool_type]);
       strcat(query,dummy);
   }
   if (SB) {
       result = cgiFormSelectSingle("GSB",choices,3,&choice,0);
       if ((result == cgiFormNotFound) || 
      (result == cgiFormEmpty))
      Error("Invalid form");
       sprintf(dummy," SB %s %d %s", choices[choice], 
      SB, bool_types[bool_type]);
       strcat(query,dummy);
   }
   if (BB) {
       result = cgiFormSelectSingle("GBBB",choices,3,&choice,
      0);
       if ((result == cgiFormNotFound) || 
      (result == cgiFormEmpty))
      Error("Invalid form");
       sprintf(dummy," BB %s %d %s", choices[choice], 
      BB, bool_types[bool_type]);
       strcat(query,dummy);
   }
   if (SO) {
       result = cgiFormSelectSingle("GSOB",choices,3,&choice,
      0);
       if ((result == cgiFormNotFound) || 
      (result == cgiFormEmpty))
      Error("Invalid form");
       sprintf(dummy," SO %s %d %s", choices[choice], 
      SO, bool_types[bool_type]);
       strcat(query,dummy);
   }

   length = strlen(query);
   b_length = strlen(bool_types[bool_type]);
   for(i = length-b_length ; i <= length ; i++) {
       query[i] = 0;
   }
    }
    strcat(query," order by lname, fname");
    return;
}

void PerformQuery(char *query) {
    int i;
    char dummy[512];
    char lname_prev[51]; /* This hold the last name looked at */
    char fname_prev[51];

    /* mSQL variables */
    m_result *msql_out;
    m_row msql_data;
    int dbh = 0;
    int msql_result = 0;

    dbh = msqlConnect(NULL);
    if (dbh == -1)
   Error("Database Error: Could not connect to mSQL server");

    msql_result = msqlSelectDB(dbh,"test");
    if (msql_result == -1) {
   msqlClose(dbh);
   Error("Database Error: Could not select database");
    }

    msql_result = msqlQuery(dbh,query);
    if (msql_result == -1) {
   msqlClose(dbh);
   sprintf(dummy, "Database Error: Select Query not successful:
          %s :: %s", msqlErrMsg, query);
   Error(dummy);
    }
    if (msql_result == 0) {
   msqlClose(dbh);
   fprintf(cgiOut, "<h1>Sorry</h1>");
   fprintf(cgiOut, "<p>No players matched your criteria");
   fprintf(cgiOut, "<p><A HREF=\".\">Search</a> again.");
   return;
    }

    /* Initialize lname_prev and fname_prev */
    lname_prev[0] = fname_prev[0] = 0;

    /* After this point, we *must* call msqlFreeResult before any
    exit points */
    msql_out = msqlStoreResult();

    fprintf(cgiOut, "<h1>%d successful matches!</h1>", msql_result);
    fprintf(cgiOut, "<p>\n");
    /* Go through the results */
    while (msql_data = msqlFetchRow(msql_out)) {
   /* If this is the first time through, start the list and print
   the entry */
   if (!lname_prev[0]) {
       fprintf(cgiOut, "<UL>\n");
       fprintf(cgiOut, "<LI><B>%s</b>,</li>\n", msql_data[2]);
       fprintf(cgiOut, "<UL>\n");
       fprintf(cgiOut, "<LI>%s: ", msql_data[1]);
       fprintf(cgiOut, 
      "<A HREF=\"change_form.cgi?id=%s\">%s</a> ",
      msql_data[0], msql_data[3]);
   /* If this is a new last name, end the old last name and start a
   new one */
   } else if (strcmp(msql_data[2],lname_prev)) {
       fprintf(cgiOut, "</li>\n</li></ul>\n");
       fprintf(cgiOut, "<LI><B>%s</b>,</li>\n", msql_data[2]);
       fprintf(cgiOut, "<UL>\n");
       fprintf(cgiOut, "<LI>%s: ", msql_data[1]);
       fprintf(cgiOut, 
      "<A HREF=\"change_form.cgi?id=%s\">%s</a> ",
      msql_data[0], msql_data[3]);
   /* If this is a new first name, end the old first name and start 
   a new one */
   } else if (strcmp(msql_data[1],fname_prev)) {
       fprintf(cgiOut, "</li>\n");
       fprintf(cgiOut, "<LI>%s: ", msql_data[1]);
       fprintf(cgiOut, 
      "<A HREF=\"change_form.cgi?id=%s\">%s</a> ",
      msql_data[0], msql_data[3]);
   /* This must be the same person, just add another year to their 
   list. */
   } else {
       fprintf(cgiOut, 
      "<A HREF=\"change_form.cgi?id=%s\">%s</a> ",
      msql_data[0], msql_data[3]);
   }
   /* Set the previous names to the current names */
   strcpy(fname_prev,msql_data[1]);
   strcpy(lname_prev,msql_data[2]);
    }
    fprintf(cgiOut, "</li></li></ul></ul>\n");
    fprintf(cgiOut, "<p><A HREF=\"change.html\">Search</a> for another
player to change.");
    msqlFreeResult(msql_out);
    return;
}


void Error(char *error) {
    fprintf(cgiOut, "<HTML><HEAD>\n");
    fprintf(cgiOut, "<TITLE>Error</title>\n");
    fprintf(cgiOut, "<BODY>\n");
    fprintf(cgiOut, "<H1>There was an error in your submission:</h1>\n");
    fprintf(cgiOut, "<p>%s", error);
    fprintf(cgiOut, 
           "<p><a href=\"change.html\">Go</a> back and try again.");
    fprintf(cgiOut, "</body></html>\n");
    exit(0);
}

void HandleYear(char *yearStr, int bool_type, int choice)
    {

    int num_year, num_year1, num_year2;
    char *year1;
    char *year2;
    char dummy[50] = "";

    if (!strchr(year,'-')) {
   num_year = atoi(year);
   if (! num_year)
       Error("The year must be a numeric value");
   if (num_year < 1800)
       num_year += 1900;
   if (num_year < 1850)
       Error("The year entered is not a reasonable value");
   sprintf(dummy," year %s %d %s", choices[choice], num_year, 
       bool_types[bool_type]);
   strcat(yearStr,dummy);
   return;
    }
    year1 = (char *)strtok(year,"-");
    year2 = (char *)strtok(NULL,"-");
    num_year1 = atoi(year1);
    num_year2 = atoi(year2);
    if (!num_year1 || !num_year2)
   Error("Year ranges must be of one these formats: ####-####, ##-##, 
####-## or ##-####");
    if (num_year1 < 1800)
   num_year1 += 1900;
    if (num_year2 < 1800)
   num_year2 += 1900;
    if ((num_year1 < 1850) || (num_year2 < 1850))
   Error("One of the years entered is not a reasonable value");
    if (choice == 2)
   sprintf(dummy," year > %d %s", num_year2, bool_types[bool_type]);
    else if (choice == 0)
   sprintf(dummy," year < %d %s", num_year1, bool_types[bool_type]);
    else
   sprintf(dummy," (year > %d and year < %d) %s",
       num_year1, num_year2, bool_types[bool_type]);
    strcat(yearStr,dummy);
    return;
}

[AO1]I'd prefer "unreasonably large" in these messages
