#include <stdio.h>
#include <stdlib.h>
#include <cgic.h>
#include <time.h>
#include <msql.h>

char fname[51];
char lname[51];
char positionString[51];

void Error(char *);
void CreateQuery(char *);
void PerformQuery(char *);

int cgiMain() {
    char query[512];

    cgiHeaderContentType("text/html");
    
    CreateQuery(query);

    fprintf(cgiOut, "<HTML><HEAD>\n");       
    PerformQuery(query);
    fprintf(cgiOut, "<A HREF=\".\">Search</a> again\n");
    fprintf(cgiOut, "</body></html>\n");
    return 0;
}

void CreateQuery(char *query) {
    int result;
    char id[5];

    /* mSQL variables */
    m_result *msql_out;
    m_row msql_data;
    int dbh = 0;
    int msql_result = 0;

    result = cgiFormStringNoNewlines("fname",fname,51);
    if ((result == cgiFormNotFound) || (result == cgiFormEmpty))
   Error("Your form must include a first name and a last name");
    else if (result == cgiFormTruncated)
   Error("Names cannot be longer than 50 characters.");

    result = cgiFormStringNoNewlines("lname",lname,51);
    if ((result == cgiFormNotFound) || (result == cgiFormEmpty))
   Error("Your form must include a first name and a last name");
    else if (result == cgiFormTruncated)
   Error("Names cannot be longer than 50 characters.");

    /* The first query we sent, finds out the position of the player in 
    question. We assume that the player does not change positions during
    his or her career and so we only need to read in one year. */
    sprintf(query, "select position from baseball where fname='%s' 
      and lname='%s' limit 1", fname, lname);

    dbh = msqlConnect(NULL);
    if (dbh == -1)
   Error("Database Error: Could not connect to mSQL server");
 
    msql_result = msqlSelectDB(dbh,"test");
    if (msql_result == -1) {
   msqlClose(dbh);
   Error("Database Error: Could not select database");
    }

    msql_result = msqlQuery(dbh,query);
    if (msql_result == -1) {
   msqlClose(dbh);
   Error("Database Error: Insert query not successful");
    }

    /* If we don't get a result back, the player doesn't exist */
    if (msql_result == 0) {
   msqlClose(dbh);
   Error("No such player!");
    }
    /* After this point, we *must* call msqlFreeResult() before any
    exit point */
    msql_out = msqlStoreResult();
    /* We asked for only one row, so we need to call msqlFetchRow()
    only once */
    msql_data = msqlFetchRow(msql_out);
    /* Read the position into the positionString */
    strcpy(positionString,msql_data[0]);
    /* free the result memory */
    msqlFreeResult(msql_out);

    /* Construct the 'real' query depending on whether the player is a 
    pitcher or a non-pitcher. Note that there is no need to ask for fname,
    lname or position since we already have all of those. */
    if (strchr(positionString,'P'))
   sprintf(query, "select year, club, G, W, L, IP, R, ER, SO, BB,
GS, CG, SHO, SV from baseball where fname='%s' and lname='%s' order by year",
       fname, lname);
    else
   sprintf(query, "select year, club, G, AB, R, H, B2, B3, HR, RBI,
SB, BB, SO from baseball where fname='%s' and lname='%s' order by year",
       fname, lname);
    /* Done */
    return;
}

void PerformQuery(char *query) {
    int i;

    /* These hold the total values for the stats */
    int TG=0; int TAB=0; int TR=0; int TH=0; int TB2=0; int TB3=0;
    int THR=0; int TRBI=0; int TSB=0; int TBB=0; int TSO=0;
    int TW=0; int TL=0; int TER=0; int TGS=0; int TCG=0; int TSHO=0;
    int TSV=0;
    double TIP=0.0;

    /* These are needed to calculate the era, slugging and avg */
    double era, H, B2, B3, HR, AB, IP, ER, slugging, avg;

    /* mSQL variables */
    m_result *msql_out;
    m_row msql_data;
    int dbh = 0;
    int msql_result = 0;

    dbh = msqlConnect(NULL);
    if (dbh == -1)
   Error("Database Error: Could not connect to mSQL server");

    msql_result = msqlSelectDB(dbh,"test");
    if (msql_result == -1) {
   msqlClose(dbh);
   Error("Database Error: Could not select database");
    }

    msql_result = msqlQuery(dbh,query);
    if (msql_result == -1) {
   msqlClose(dbh);
   Error("Database Error: Insert query not successful");
    }
    /* This should never happen, but it's best to be safe. */
    if (msql_result == 0) {
   msqlClose(dbh);
   Error("No player data!");
    }

    /* After this point we *must* call msqlFreeResult before any
    exit points. */
    msql_out = msqlStoreResult();

    /* Turn the ':'s in the positionString to '/'s. This is how
    the positions look on most baseball cards (e.g. '1B/OF') */
    for(i=0; i<(signed)strlen(positionString); i++) {
   if (positionString[i] == ':')
       positionString[i] = '/';
    }

    /* Start the HTML page, including the table that will hold the data. */
    fprintf(cgiOut, "<TITLE>%s %s</title>", fname, lname);
    fprintf(cgiOut, "</head><body>\n");
    fprintf(cgiOut, "<TABLE BORDER WIDTH=100%>\n");
    fprintf(cgiOut, "<TR><TH>%s %s * %s</th></tr>\n", fname, lname,
   positionString);
    fprintf(cgiOut, "</table>\n<p>\n");
    fprintf(cgiOut, 
   "<TABLE BORDER=0 WIDTH=100% CELLSPACING=0 CELLPADDING=0>\n");

    /* Print the table header, which will be different for pitchers and for
    non-pitchers */
    if (strchr(positionString,'P'))
   fprintf(cgiOut,
"<TR><TD>Year</td> <TD>Club</td> <TD>G</td> <TD>IP</td> <TD>W</td>
<TD>L</td> <TD>R</td> <TD>ER</td> <TD>SO</td> <TD>BB</td> <TD>GS</td>
<TD>CG</td> <TD>SHO</td> <TD>SV</td> <TD>ERA</td></tr>\n");
    else
   fprintf(cgiOut,
"<TR><TD>Year</td> <TD>Club</td> <TD>G</td> <TD>AB</td> <TD>R</td>
<TD>H</td> <TD>2B</td> <TD>3B</td> <TD>HR</td> <TD>RBI</td> <TD>SB</td>
<TD>SLG</td> <TD>BB</td> <TD>SO</td> <TD>AVG</td></tr>\n");

    fprintf(cgiOut, "<TR><TD COLSPAN=15><HR></td></tr>\n");

    /* Start running through the results, one by one */
    while (msql_data = msqlFetchRow(msql_out)) {
   fprintf(cgiOut, "<TR>\n");
   /* The first 3, ('Year', 'Club' and 'Games') we can just
   print out */
   for(i=0;i<3;i++)
       fprintf(cgiOut, "<TD>%s</td> ", msql_data[i]);

   /* If it's a pitcher we have to put 'IP' before 'W' and 'L' */
   if (strchr(positionString,'P')) {
       fprintf(cgiOut,"<TD>%s</td> <TD>%s</td> <TD>%s</td> ",
      msql_data[5], msql_data[3], msql_data[4]);
   } else {
       for(i=3;i<6;i++)
      fprintf(cgiOut, "<TD>%s</td> ", msql_data[i]);
   }

   /* The next few aren't involved in any calculations for either
   pitchers or non-pitchers so we can just print them out. */
   for(i=6;i<11;i++)
       fprintf(cgiOut, "<TD>%s</td> ", msql_data[i]);

   /* This is the pitcher-specific stuff */
   if (strchr(positionString,'P')) {
       /* Increment the totals. Don't forget that IP is a 
       double. */
       TG+=atoi(msql_data[2]); TW+=atoi(msql_data[3]); 
       TL+=atoi(msql_data[4]); TIP+=atof(msql_data[5]); 
       TR+=atoi(msql_data[6]); TER+=atoi(msql_data[7]);
       TSO+=atoi(msql_data[8]); TBB+=atoi(msql_data[9]); 
       TGS+=atoi(msql_data[10]); TCG+=atoi(msql_data[11]);
       TSHO+=atoi(msql_data[12]); TSV+=atoi(msql_data[13]);

       /* Print out everything except the ERA */
       fprintf(cgiOut, "<TD>%s</td> <TD>%s</td> <TD>%s</td> ",
      msql_data[11], msql_data[12], msql_data[13]);

       /* Set the ER and IP and calculate the ERA */[AO1]
       ER = (double)atoi(msql_data[7]);
       IP = atof(msql_data[5]);
       era = ER * 9.0 / IP;

       /* Print the ERA and end the row */
       fprintf(cgiOut, "<TD>%.2f</td>\n", era);
       fprintf(cgiOut, "</tr>\n");
   } else {

       TG+=atoi(msql_data[2]); TAB+=atoi(msql_data[3]); 
       TR+=atoi(msql_data[4]); TH+=atoi(msql_data[5]); 
       TB2+=atoi(msql_data[6]); TB3+=atoi(msql_data[7]);
       THR+=atoi(msql_data[8]); TRBI+=atoi(msql_data[9]); 
       TSB+=atoi(msql_data[10]); TBB+=atoi(msql_data[11]);
       TSO+=atoi(msql_data[12]);

       /* Set the values needed for slugging and avg */
       H = (double)atoi(msql_data[5]);
       B2 = (double)atoi(msql_data[6]);
       B3 = (double)atoi(msql_data[7]);
       HR = (double)atoi(msql_data[8]);
       AB = (double)atoi(msql_data[3]);

       /* Calculate and print the slugging percentage */
       slugging = ( (H-B2-B3-HR) + B2*2.0 + B3*3.0 + HR*4.0 ) 
      / AB;
       fprintf(cgiOut, "<TD>%.3f</td> ",slugging);

       /* Strike outs and walks go between slugging and avg. */
       fprintf(cgiOut, "<TD>%s</td> <TD>%s</td> ",
      msql_data[11], msql_data[12]);

       /* Calculate and print the batting average. */
       avg = H / AB;
       fprintf(cgiOut, "<TD>%.3f</td>\n", 
      avg);
       fprintf(cgiOut, "</tr>\n");
   }
    }

    /* Now we print out the totals */
    fprintf(cgiOut, "<TR><TD COLSPAN=15><HR></td></tr>\n");
    fprintf(cgiOut, "<TR><TD COLSPAN=2>Totals</td> ");
    if (strchr(positionString,'P')) {
   fprintf(cgiOut, "<TD>%d</td> <TD>%3.1f</td> <TD>%d</td>
<TD>%d</td> <TD>%d</td> <TD>%d</td> <TD>%d</td> <TD>%d</td> <TD>%d</td>
<TD>%d</td> <TD>%d</td> <TD>%d</td> ", TG, TIP, TW, TL, TR, TER, TSO,
TBB, TGS, TCG, TSHO, TSV);
   era = (float)TER * 9 / TIP;
   fprintf(cgiOut, "<TD>%.2f</td></tr>\n", era);
    } else {
   fprintf(cgiOut, "<TD>%d</td> <TD>%d</td> <TD>%d</td> <TD>%d</td>
<TD>%d</td> <TD>%d</td> <TD>%d</td> <TD>%d</td> <TD>%d</td> ", TG, TAB, TR, TH, 
TB2, TB3, THR, TRBI, TSB);
   slugging = ( ((float)TH-(float)TB2-(float)TB3-(float)THR) + 
       (float)TB2*2.0 + (float)TB3*3.0 + (float)THR*4.0 ) / 
       (float)TAB;
   fprintf(cgiOut, "<TD>%.3f</td> ", slugging);
   fprintf(cgiOut, "<TD>%d</td> <TD>%d</td> ", TBB, TSO);
   avg = (float)TH / (float)TAB;
   fprintf(cgiOut, "<TD>%.3f</td></tr>\n", avg);
    }

    /* Free the results memory and leave */
    msqlFreeResult(msql_out);
    fprintf(cgiOut, "</table>\n");

    return;
}

void Error(char *error) {
    fprintf(cgiOut, "<HTML><HEAD>\n");
    fprintf(cgiOut, "<TITLE>Error</title>\n");
    fprintf(cgiOut, "<BODY>\n");
    fprintf(cgiOut, "<H1>There was an error in your submission:</h1>\n");
    fprintf(cgiOut, "<p>%s", error);
    fprintf(cgiOut, "<p><a href=\"search.html\">Go</a> back and try again.");
    fprintf(cgiOut, "</body></html>\n");
    exit(0);
}

[AO1]
