#include <stdio.h>
#include <cgic.h> /* This is the CGIC library from Boutell, Inc. */
#include <time.h> /* <time.h> is required by msql.h */
#include <msql.h> /* This is the mSQL library */

#define PITCHER  0 /* Mnemonics for the player positions */
#define CATCHER  1
#define FIRST_B  2
#define SECOND_B 3
#define THIRD_B  4
#define SHORT    5
#define OUTFIELD 6
#define DES_HIT  7

char *positions[] = { /* The array of positions with the labels as used */
    "P",      /* on the HTML form. This is used by CGIC to interpret */
    "C",      /* the form data. */
    "B1",
    "B2",
    "B3",
    "SS",
    "OF",
    "DH"
};

char fname[51]; /* Player's first name */
char lname[51]; /* Player's last name */
char club[51];  /* Club (e.g. Reds, Tigers, etc. )
int year, G, W, L, R, ER, SO, BB, GS, CG, SHO, SV, AB, H, B2, B3, HR,
    RBI, SB; /* The integer stats. R, BB, and SO are used for both pitchers
    and other players */
double IP; /* Innings pitched must be a float to allow for fractional innings */

void Error(char *); /* Prints a nice HTML error page and exits */
void CreateQuery(char *, char *); /* Creates the SQL query */
void PerformQuery(char *); /* Performs the SQL query */
void GetId(char *); /* Obtains the next ID number in the sequence */

/* All CGIC programs must use cgiMain() instead of main() */
int cgiMain() {
    char query[512]; /* The SQL query */
    char id[6]; /* Player's ID number */

    cgiHeaderContentType("text/html"); /* Send the HTTP header to the browser 
                                       */
    
    GetId(id); /* Get the ID number. Note that the ID is a char, so it is 
      passed by value */
    CreateQuery(id, query); /* Create the SQL query */
    PerformQuery(query); /* Send the Query to the database server &/

     /* This is a page sent to the user indicating success. If there was
    * some sort of failure, the Error() function would have been called before 
    *  now
    */[AO1]
    fprintf(cgiOut, "<HTML><HEAD>\n");
    fprintf(cgiOut, "<TITLE>Information Added!</TITLE></HEAD>\n");
    fprintf(cgiOut, 
"<BODY><H1>The player information has been successfully added</H1>\n");
    fprintf(cgiOut, "<A HREF=\"add.html\">Add</a> another player/season.
   <br>");
    fprintf(cgiOut, "<A HREF=\".\">Search</a> the database.<br>");
    fprintf(cgiOut, "<A HREF=\"change.html\">Change</a> a database entry.
    <br>");
    fprintf(cgiOut, "</body></html>\n");

   /* See ya later */
   return 0;
}

/* Create the SQL query
* The ID number (as a string) and the string
 * to hold the query are passed in.
*/
void CreateQuery(char *id, char *query) {
   int positionsChosen[8]; /* This array has one int for each position.
         CGIC will set a positive value for each position
      that was submitted by the form. The rest will be
      set to '0'.*/
    int result, invalid, i; /* 'result' holds the CGI results codes.
          'invalid holds a special result code for  
          cgiFormCheckboxMultiple()
          'i' is a generic counter
      */
    char positionString[25] = ""; /* This holds the positions chosen in the 
            format expected by the database ('C:SS:OF')
            */

    /* This reads in the form value for 'fname'. If a value wasn't submitted
    or if it was too long, we call Error() */
    result = cgiFormStringNoNewlines("fname",fname,51);
    if ((result == cgiFormNotFound) || (result == cgiFormEmpty))
   Error("Your form must include a first name, a last name
and at least one position.");
    else if (result == cgiFormTruncated)
   Error("Names cannot be longer than 50 characters.");

    result = cgiFormStringNoNewlines("lname",lname,51);
    if ((result == cgiFormNotFound) || (result == cgiFormEmpty))
   Error("Your form must include a first name, a last name
and at least one position.");
    else if (result == cgiFormTruncated)
   Error("Names cannot be longer than 50 characters.");

    result = cgiFormStringNoNewlines("club",club,51);
    if (result == cgiFormTruncated)
   Error("Club names cannot be longer than 50 characters.");


    /* This reads in the values for the multiple checkbox 'position'.
    The values are set by setting the appropriate places in the 
    'positionsChosen' array to positive values */
    result = cgiFormCheckboxMultiple("position",positions,8,
   positionsChosen, &invalid);
    if (invalid)
   Error("Invalid form data was submitted");
    if ((result == cgiFormNotFound) || (result == cgiFormEmpty))
   Error("Your form must include a first name, a last name
and at least one position.");

    if (positionsChosen[PITCHER])
   /* Add 'P' to the position string. We could just as well use
   strcpy() here since if pitcher is chosen, no other position is
   allowed */
   strcat(positionString, "P");
    /* Go through all of the positions except for pitcher */
    for (i=1; (i<8); i++) { 
   if (positionsChosen[PITCHER] && positionsChosen[i])
       Error("Players who were both pitchers and non-pitchers
in the same season are not supported yet.");
   /* If it's the first position chosen, initialize the string with 
   the position */
   if (positionsChosen[i] && (positionString[0] == 0))
       strncpy[AO2](positionString, positions[i],25);
   /* Else, add the position on with a ':' */
   else if (positionsChosen[i]) {
       strcat(positionString, ":");
       strcat(positionString, positions[i]);
   }
    }

    /* Read in the 'year' field. Allow for 4-digit years and 2-digit years within    
   the 20th century. Total range of years allowed is 1850 through 9999. If
   this program, the C language and baseball are all still around in 9999, then
   someone else can update it. 
       */
    result = cgiFormIntegerBounded("year",&year,0,9999,0);
    if (result == cgiFormConstrained)
   Error("One of the numeric form values was either less
than zero or unreasonably large.");
    if (year < 1800)
   year += 1900;
    if (year < 1850)
   Error("The year entered is not a reasonable value");

    /* Read in the 'G' field. (Games played). 
    NOTE: The only reason boundaries are set for this field, and for
    all of the other numerical fields is to limit their size when
    converted to char(). This allows us to be certain that the query
    string will never exceed the maximum length. Otherwise we'd have to
    do a lot of strlen() checking when building the query string later on.
    (Or leave the program open to buffer overflow attacks.)
[AO3]    */
    result = cgiFormIntegerBounded("G",&G,0,999,0);
    if (result == cgiFormConstrained)
   Error("One of the numeric form values was either less
than zero or unreasonably large: G");

    /* If pitcher is chosen, we read in a certain set of the fields:
    W, L, IP, RP, RP (R), ER, SOP (SO), BBP (BB), GS, CG, SHO and SV */
    if (positionsChosen[PITCHER]) {
   result = cgiFormIntegerBounded("W",&W,0,99,0);
   if (result == cgiFormConstrained)
       Error("One of the numeric form values was either less
than zero or unreasonably large: W");
   result = cgiFormIntegerBounded("L",&L,0,99,0);
   if (result == cgiFormConstrained)
       Error("One of the numeric form values was either less
than zero or unreasonably large: L");
   result = cgiFormDoubleBounded("IP",&IP,0.0,999.0,0.0);
   if (result == cgiFormConstrained)
       Error("One of the numeric form values was either less
than zero or unreasonably large: IP");
   result = cgiFormIntegerBounded("RP",&R,0,999,0);
   if (result == cgiFormConstrained)
       Error("One of the numeric form values was either less
than zero or unreasonably large: R");
   result = cgiFormIntegerBounded("ER",&ER,0,999,0);
   if (result == cgiFormConstrained)
       Error("One of the numeric form values was either less
than zero or unreasonably large: ER");
   result = cgiFormIntegerBounded("SOP",&SO,0,999,0);
   if (result == cgiFormConstrained)
       Error("One of the numeric form values was either less
than zero or unreasonably large: SO");
   result = cgiFormIntegerBounded("BBP",&BB,0,999,0);
   if (result == cgiFormConstrained)
       Error("One of the numeric form values was either less
than zero or unreasonably large: BB");
   result = cgiFormIntegerBounded("GS",&GS,0,99,0);
   if (result == cgiFormConstrained)
       Error("One of the numeric form values was either less
than zero or unreasonably large: GS");
   result = cgiFormIntegerBounded("CG",&CG,0,99,0);
   if (result == cgiFormConstrained)
       Error("One of the numeric form values was either less
than zero or unreasonably large: CG");
   result = cgiFormIntegerBounded("SHO",&SHO,0,99,0);
   if (result == cgiFormConstrained)
       Error("One of the numeric form values was either less
than zero or unreasonably large: SHO");
   result = cgiFormIntegerBounded("SV",&SV,0,99,0);
   if (result == cgiFormConstrained)
       Error("One of the numeric form values was either less
than zero or unreasonably large: SV");

    /* Now that all of the fields are read in we can build the query
    string. */
   sprintf(query, "insert into baseball (id, fname, lname,
position, year, club, G, W, L, IP, R, ER, SO, BB, GS, CG, SHO, SV) values
('%s','%s','%s','%s', %d, '%s', %d, %d, %d, %3.1f, %d, %d, %d, %d, %d, %d, 
%d, %d)", id, fname, lname, positionString, year, club, G, W, L, IP, R, ER, 
SO, BB, GS, CG, SHO, SV);
    } else {
   /* If the player is not a pitcher, other fields are read in:
   AB, RB (R), H, B2, B3, HR, RBI, SB, BBB (BB) and SOB (SO)
   */
   result = cgiFormIntegerBounded("AB",&AB,0,999,0);
   if (result == cgiFormConstrained)
       Error("One of the numeric form values was either less
than zero or unreasonably large: AB");
   result = cgiFormIntegerBounded("RB",&R,0,999,0);
   if (result == cgiFormConstrained)
       Error("One of the numeric form values was either less
than zero or unreasonably large: R");
   result = cgiFormIntegerBounded("H",&H,0,999,0);
   if (result == cgiFormConstrained)
       Error("One of the numeric form values was either less
than zero or unreasonably large: H");
   result = cgiFormIntegerBounded("B2",&B2,0,999,0);
   if (result == cgiFormConstrained)
       Error("One of the numeric form values was either less
than zero or unreasonably large: 2B");
   result = cgiFormIntegerBounded("B3",&B3,0,99,0);
   if (result == cgiFormConstrained)
       Error("One of the numeric form values was either less
than zero or unreasonably large: 3B");
   result = cgiFormIntegerBounded("HR",&HR,0,99,0);
   if (result == cgiFormConstrained)
       Error("One of the numeric form values was either less
than zero or unreasonably large: HR");
   result = cgiFormIntegerBounded("RBI",&RBI,0,999,0);
   if (result == cgiFormConstrained)
       Error("One of the numeric form values was either less
than zero or unreasonably large: RBI");
   result = cgiFormIntegerBounded("SB",&SB,0,999,0);
   if (result == cgiFormConstrained)
       Error("One of the numeric form values was either less
than zero or unreasonably large: SB");
   result = cgiFormIntegerBounded("BBB",&BB,0,999,0);
   if (result == cgiFormConstrained)
       Error("One of the numeric form values was either less
than zero or unreasonably large: BB");
   result = cgiFormIntegerBounded("SOB",&SO,0,999,0);
   if (result == cgiFormConstrained)
       Error("One of the numeric form values was either less
than zero or unreasonably large: SO");

   /* We can now build the SQL query */
   sprintf(query, "insert into baseball (id, fname, lname,
position, year, club, G, AB, R, H, B2, B3, HR, RBI, SB, BB, SO) values
('%s','%s','%s','%s', %d, '%s', %d, %d, %d, %d, %d, %d, %d, %d, %d, %d, 
%d)", id, fname, lname, positionString, year, club, G, AB, R, H, B2, B3, HR, 
RBI, SB, BB, SO);
    }
    /* The query is now built, we can return to cgiMain() */
    return;
}

/* Perform the SQL Query */
void PerformQuery(char *query) {

    /* mSQL variables */
    m_result *msql_out; /* SELECT results */
    m_row msql_data; /* A single row of data */
    int dbh = 0; /* The database handle */
    int msql_result = 0; /* The result codes */

    /* Connect to the database server */
    dbh = msqlConnect(NULL);
    if (dbh == -1)
   Error("Database Error: Could not connect to mSQL server");

    /* Select the database. I chose 'test' for mine, with the table name 
    'baseball'.
    */
    msql_result = msqlSelectDB(dbh,"test");
    if (msql_result == -1) {
   msqlClose(dbh);
   Error("Database Error: Could not select database");
    }

    /* Send the query. This one line performs the actual purpose of the CGI    
    program. */
    msql_result = msqlQuery(dbh,query);
    if (msql_result == -1) {
   msqlClose(dbh);
   Error("Database Error: Insert query not successful");
    }

    /* If we've gotten this far, the query was successful. We can go home. 
    */
    return;
}

void GetId(char *id) {

    /* mSQL variables */
    m_result *msql_out;
    m_row msql_data;
    int dbh = 0;
    int msql_result = 0;


    /* Connect */
    dbh = msqlConnect(NULL);
    if (dbh == -1)
   Error("Database Error: Could not connect to mSQL server");

    /* SelectDB */
    msql_result = msqlSelectDB(dbh,"test");
    if (msql_result == -1) {
   msqlClose(dbh);
   Error("Database Error: Could not select database");
    }

    /* Select the next number in the sequenced defined on the table
    'baseball'.
    */
    msql_result = msqlQuery(dbh,"SELECT _seq FROM baseball");
    if (msql_result == -1) {
   msqlClose(dbh);
   Error("Database Error: Query failed");
    } else if (msql_result != 1) {
   msqlClose(dbh);
   Error("Database Error: Sequence select error");
    }
    /* This stores the data. After this point we *must* call msqlFreeResult
    before any exit point. */
    msql_out = msqlStoreResult();
    /* Retrieve the one and only row of output. */
    msql_data = msqlFetchRow(msql_out);

    /* Copy the id number into the 'id' string. */
    strncpy(id,msql_data[0],6);
    /* Just to be safe, make sure 'id' is null terminated. */
    id[6] = 0;

    /* Free the memory used by the result */
    msqlFreeResult(msql_out);
    msqlClose(dbh);
    /* Go home */
    return;
}

/* Print Error page */
void Error(char *error) {
    fprintf(cgiOut, "<HTML><HEAD>\n");
    fprintf(cgiOut, "<TITLE>Error</title>\n");
    fprintf(cgiOut, "<BODY>\n");
    fprintf(cgiOut, "<H1>There was an error in your submission:</h1>\n");
    fprintf(cgiOut, "<p>%s", error);
    fprintf(cgiOut, "<p><a href=\"add.html\">Go</a> back and try again.");
    fprintf(cgiOut, "</body></html>\n");
    exit(0);
}

[AO1]I know this is still preliminary code, but I thought I'd remind you to make the formatting of comments more attractive. Also, you can use smaller indents -- four spaces per level looks fine.
[AO2]Wouldn't strcpy or strncpy be better here just for clarity, since you're initializing the string?
[AO3]This comment is certainly useful to include for maintenance purposes, but I think it's a point you should make in the text too. Why put an upper limit on the year, by the way? If somebody asks for a year for which no stats exist, results will simply be empty. What's wrong with requesting year 9999?
