#include <stdio.h>
#include <cgic.h>
#include <time.h>
#include <msql.h>

#define PITCHER  0
#define CATCHER  1
#define FIRST_B  2
#define SECOND_B 3
#define THIRD_B  4
#define SHORT    5
#define OUTFIELD 6
#define DES_HIT  7

char *positions[] = {
    "P",
    "C",
    "B1",
    "B2",
    "B3",
    "SS",
    "OF",
    "DH"
};

char fname[51], lname[51], club[51], id[6];
int year, G, W, L, R, ER, SO, BB, GS, CG, SHO, SV, AB, H, B2, B3, HR,
    RBI, SB;
double IP;

void Error(char *);
void CreateQuery(char *, char *);
void PerformQuery(char *);

int cgiMain() {
    char query[512];

    cgiHeaderContentType("text/html");
    
    CreateQuery(id, query);
    PerformQuery(query); 

    fprintf(cgiOut, "<HTML><HEAD>\n");       
    fprintf(cgiOut, "<TITLE>Information Changed!</TITLE></HEAD>\n");
    fprintf(cgiOut, 
   "<BODY><H1>The player information has been successfully 
   added</H1>\n");
    fprintf(cgiOut, "<A HREF=\"change.html\">Change</a> another database 
      entry. <br>");
    fprintf(cgiOut, "<A HREF=\"add.html\">Add</a> a player/season.
      <br>");
    fprintf(cgiOut, "<A HREF=\".\">Search</a> the database.<br>");
    fprintf(cgiOut, "</body></html>\n");
    return 0;
}

void CreateQuery(char *id, char *query) {
    int positionsChosen[8];
    int result, invalid, i;
    char positionString[25] = "";

    result = cgiFormStringNoNewlines("fname",fname,51);
    if ((result == cgiFormNotFound) || (result == cgiFormEmpty))
   Error("Your form must include a first name, a last name
and at least one position.");
    else if (result == cgiFormTruncated)
   Error("Names cannot be longer than 50 characters.");

    /* The ID was passed along between change_search.cgi to change_form.cgi
    to here via a 'HIDDEN' text field in the form */
    result = cgiFormStringNoNewlines("id",id,6);
    if ((result == cgiFormNotFound) || (result == cgiFormEmpty))
   Error("Your form must include an ID number!");
    else if (result == cgiFormTruncated)
   Error("ID numbers cannot be longer than 5 characters.");

    result = cgiFormStringNoNewlines("lname",lname,51);
    if ((result == cgiFormNotFound) || (result == cgiFormEmpty))
   Error("Your form must include a first name, a last name
         and at least one position.");
    else if (result == cgiFormTruncated)
   Error("Names cannot be longer than 50 characters.");

    result = cgiFormStringNoNewlines("club",club,51);
    if (result == cgiFormTruncated)
   Error("Club names cannot be longer than 50 characters.");

    result = cgiFormCheckboxMultiple("position",positions,8,
   positionsChosen, &invalid);
    if (invalid)
   Error("Invalid form data was submitted");
    if ((result == cgiFormNotFound) || (result == cgiFormEmpty))
   Error("Your form must include a first name, a last name
         and at least one position.");

    if (positionsChosen[PITCHER])
   strcat(positionString, "P");
    for (i=1; (i<8); i++) { 
   if (positionsChosen[PITCHER] && positionsChosen[i])
       Error("Players who were both pitchers and non-pitchers
       in the same season are not supported yet.");
   if (positionsChosen[i] && (positionString[0] == 0))
       strcat(positionString, positions[i]);
   else if (positionsChosen[i]) {
       strcat(positionString, ":");
       strcat(positionString, positions[i]);
   }
    }

    result = cgiFormIntegerBounded("year",&year,0,9999,0);
    if (result == cgiFormConstrained)
   Error("One of the numeric form values was either less
than zero or unreasonably large.");
    if (year < 1800)
   year += 1900;
    if (year < 1850)
   Error("The year entered is not a reasonable value");

    result = cgiFormIntegerBounded("G",&G,0,999,0);
    if (result == cgiFormConstrained)
   Error("One of the numeric form values was either less
than zero or unreasonably large: G");

    if (positionsChosen[PITCHER]) {
   result = cgiFormIntegerBounded("W",&W,0,99,0);
   if (result == cgiFormConstrained)
       Error("One of the numeric form values was either less
than zero or unreasonably large: W");
   result = cgiFormIntegerBounded("L",&L,0,99,0);
   if (result == cgiFormConstrained)
       Error("One of the numeric form values was either less
than zero or unreasonably large: L");
   result = cgiFormDoubleBounded("IP",&IP,0.0,999.0,0.0);
   if (result == cgiFormConstrained)
       Error("One of the numeric form values was either less
than zero or unreasonably large: IP");
   result = cgiFormIntegerBounded("RP",&R,0,999,0);
   if (result == cgiFormConstrained)
       Error("One of the numeric form values was either less
than zero or unreasonably large: R");
   result = cgiFormIntegerBounded("ER",&ER,0,999,0);
   if (result == cgiFormConstrained)
       Error("One of the numeric form values was either less
than zero or unreasonably large: ER");
   result = cgiFormIntegerBounded("SOP",&SO,0,999,0);
   if (result == cgiFormConstrained)
       Error("One of the numeric form values was either less
than zero or unreasonably large: SO");
   result = cgiFormIntegerBounded("BBP",&BB,0,999,0);
   if (result == cgiFormConstrained)
       Error("One of the numeric form values was either less
than zero or unreasonably large: BB");
   result = cgiFormIntegerBounded("GS",&GS,0,99,0);
   if (result == cgiFormConstrained)
       Error("One of the numeric form values was either less
than zero or unreasonably large: GS");
   result = cgiFormIntegerBounded("CG",&CG,0,99,0);
   if (result == cgiFormConstrained)
       Error("One of the numeric form values was either less
than zero or unreasonably large: CG");
   result = cgiFormIntegerBounded("SHO",&SHO,0,99,0);
   if (result == cgiFormConstrained)
       Error("One of the numeric form values was either less
than zero or unreasonably large: SHO");
   result = cgiFormIntegerBounded("SV",&SV,0,99,0);
   if (result == cgiFormConstrained)
       Error("One of the numeric form values was either less
than zero or unreasonably large: SV");

   /* The query generated here is an 'UPDATE' as opposed to the
   'INSERT' used in add.cgi */
   sprintf(query, "update baseball set fname='%s', lname='%s',
position='%s', year=%d, club='%s', G=%d, W=%d, L=%d, IP=%3.1f, R=%d, ER=%d, 
SO=%d, BB=%d, GS=%d, CG=%d, SHO=%d, SV=%d where id='%s'", fname, lname, 
positionString, year, club, G, W, L, IP, R, ER, SO, BB, GS, CG, SHO, SV, id);
    } else {
   result = cgiFormIntegerBounded("AB",&AB,0,999,0);
   if (result == cgiFormConstrained)
       Error("One of the numeric form values was either less
than zero or unreasonably large: AB");
   result = cgiFormIntegerBounded("RB",&R,0,999,0);
   if (result == cgiFormConstrained)
       Error("One of the numeric form values was either less
than zero or unreasonably large: R");
   result = cgiFormIntegerBounded("H",&H,0,999,0);
   if (result == cgiFormConstrained)
       Error("One of the numeric form values was either less
than zero or unreasonably large: H");
   result = cgiFormIntegerBounded("B2",&B2,0,999,0);
   if (result == cgiFormConstrained)
       Error("One of the numeric form values was either less
than zero or unreasonably large: 2B");
   result = cgiFormIntegerBounded("B3",&B3,0,99,0);
   if (result == cgiFormConstrained)
       Error("One of the numeric form values was either less
than zero or unreasonably large: 3B");
   result = cgiFormIntegerBounded("HR",&HR,0,99,0);
   if (result == cgiFormConstrained)
       Error("One of the numeric form values was either less
than zero or unreasonably large: HR");
   result = cgiFormIntegerBounded("RBI",&RBI,0,999,0);
   if (result == cgiFormConstrained)
       Error("One of the numeric form values was either less
than zero or unreasonably large: RBI");
   result = cgiFormIntegerBounded("SB",&SB,0,999,0);
   if (result == cgiFormConstrained)
       Error("One of the numeric form values was either less
than zero or unreasonably large: SB");
   result = cgiFormIntegerBounded("BBB",&BB,0,999,0);
   if (result == cgiFormConstrained)
       Error("One of the numeric form values was either less
than zero or unreasonably large: BB");
   result = cgiFormIntegerBounded("SOB",&SO,0,999,0);
   if (result == cgiFormConstrained)
       Error("One of the numeric form values was either less
than zero or unreasonably large: SO");

   sprintf(query, "update baseball set fname='%s', lname='%s',
position='%s', year=%d, club='%s', G=%d, AB=%d, R=%d, H=%d, B2=%d, B3=%d, 
HR=%d, RBI=%d, SB=%d, BB=%d, SO=%d where id='%s'", fname, lname, 
positionString, year, club, G, AB, R, H, B2, B3, HR, RBI, SB, BB, SO, id);
    }
    return;
}

void PerformQuery(char *query) {
    m_result *msql_out;
    m_row msql_data;
    int dbh = 0;
    int msql_result = 0;

    dbh = msqlConnect(NULL);
    if (dbh == -1)
   Error("Database Error: Could not connect to mSQL server");

    msql_result = msqlSelectDB(dbh,"test");
    if (msql_result == -1) {
   msqlClose(dbh);
   Error("Database Error: Could not select database");
    }

    msql_result = msqlQuery(dbh,query);
    if (msql_result == -1) {
   msqlClose(dbh);
   Error("Database Error: Update query not successful");
    }

    return;
}

void Error(char *error) {
    fprintf(cgiOut, "<HTML><HEAD>\n");
    fprintf(cgiOut, "<TITLE>Error</title>\n");
    fprintf(cgiOut, "<BODY>\n");
    fprintf(cgiOut, "<H1>There was an error in your submission:</h1>\n");
    fprintf(cgiOut, "<p>%s", error);
    fprintf(cgiOut, 
            "<p><a href=\"change.html\">Go</a> back and try again.");
    fprintf(cgiOut, "</body></html>\n");
    exit(0);
}


