#include <stdio.h>
#include <stdlib.h>
#include <cgic.h>
#include <time.h>
#include <msql.h>

#define PITCHER  0
#define CATCHER  1
#define FIRST_B  2
#define SECOND_B 3
#define THIRD_B  4
#define SHORT    5
#define OUTFIELD 6
#define DES_HIT  7

char *positions[] = {
    "P",
    "C",
    "B1",
    "B2",
    "B3",
    "SS",
    "OF",
    "DH"
};

/* These are needed to print out the select box with the
positions */
char *position_names[] = {
    "Pitcher",
    "Catcher",
    "1st Baseman",
    "2nd Baseman",
    "3rd Baseman",
    "Shortstop",
    "Outfield",
    "Designated Hitter"
};

char id[5];
char positionString[51];

void Error(char *);
void CreateQuery(char *, char *);
void PerformQuery(char *);

int cgiMain() {
    char query[512];

    cgiHeaderContentType("text/html");
    
    CreateQuery(id, query);

    fprintf(cgiOut, "<HTML><HEAD>\n");       
    PerformQuery(query);
    fprintf(cgiOut, "</body></html>\n");
    return 0;
}

void CreateQuery(char *id, char *query) {
    int result;
    m_result *msql_out;
    m_row msql_data;
    int dbh = 0;
    int msql_result = 0;

    /* All we are expecting is an id from the previous page */
    result = cgiFormStringNoNewlines("id",id,5);
    if ((result == cgiFormNotFound) || (result == cgiFormEmpty))
   Error("Your form must include an ID number");
    else if (result == cgiFormTruncated)
   Error("ID numbers cannot be longer than 5 characters.");

    /* First we need to find out what position the player is */
    sprintf(query, "select position from baseball where id='%s'", id);

    dbh = msqlConnect(NULL);
    if (dbh == -1)
   Error("Database Error: Could not connect to mSQL server");
 
    msql_result = msqlSelectDB(dbh,"test");
    if (msql_result == -1) {
   msqlClose(dbh);
   Error("Database Error: Could not select database");
    }

    msql_result = msqlQuery(dbh,query);
    if (msql_result == -1) {
   msqlClose(dbh);
   Error("Database Error: Insert query not successful");
    }
    if (msql_result == 0) {
   msqlClose(dbh);
   Error("No such player!");
    }
    msql_out = msqlStoreResult();
    msql_data = msqlFetchRow(msql_out);
    strcpy(positionString,msql_data[0]);
    msqlFreeResult(msql_out);

    /* The 'real' query is now generated based on whether the player is
    a pitcher or a non-pitcher */
    if (strchr(positionString,'P'))
   sprintf(query, "select fname, lname, year, club, G, W, L, IP, R, 
 ER, SO, BB, GS, CG, SHO, SV from baseball where id='%s'", id);
    else
   sprintf(query, "select fname, lname, year, club, G, AB, R, H, B2, 
B3, HR, RBI, SB, BB, SO from baseball where id='%s'", id);
    return;
}

void PerformQuery(char *query) {
    int i;

    /* We're not doing any arithmetic this time, so the stats can stay
    as strings. This makes it easy to paste them into the form 
    */
    char G[4], AB[4], RP[4], RB[4], H[4], B2[4], B3[4], HR[4],
    RBI[4], SB[4], BBP[4], BBB[4], SOP[4], SOB[4], W[4], L[4], ER[4], GS[4],
    CG[4], SHO[4], SV[4], year[5], IP[4];
    char fname[51];
    char lname[51];
    char club[51];

    /* This array will indicate[AO1] which positions are held by the player. A 
       '1' will indicate that the player belongs to the indicated position 
       and a '0' means he doesn't. 
    */
    int positions_held[8] = { 0, 0, 0, 0, 0, 0, 0, 0 };

    /* mSQL variables */
    m_result *msql_out;
    m_row msql_data;
    int dbh = 0;
    int msql_result = 0;

    dbh = msqlConnect(NULL);
    if (dbh == -1)
   Error("Database Error: Could not connect to mSQL server");

    msql_result = msqlSelectDB(dbh,"test");
    if (msql_result == -1) {
   msqlClose(dbh);
   Error("Database Error: Could not select database");
    }

    msql_result = msqlQuery(dbh,query);
    if (msql_result == -1) {
   msqlClose(dbh);
   Error("Database Error: Insert query not successful");
    }
    if (msql_result == 0) {
   msqlClose(dbh);
   Error("No player data!");
    }

    msql_out = msqlStoreResult();
    msql_data = msqlFetchRow(msql_out);

    strcpy(fname,msql_data[0]);
    strcpy(lname,msql_data[1]);
    strcpy(year,msql_data[2]);
    strcpy(club,msql_data[3]);
    strcpy(G,msql_data[4]);

    /* This flags the appropriate value in positions_held if
    the player has that position */
    if (strchr(positionString,'P'))
   positions_held[PITCHER] = 1;
    else if (strchr(positionString,'C'))
   positions_held[CATCHER] = 1;
    else if (strstr(positionString,"B1"))
   positions_held[FIRST_B] = 1;
    else if (strstr(positionString,"B2"))
   positions_held[SECOND_B] = 1;
    else if (strstr(positionString,"B3"))
   positions_held[THIRD_B] = 1;
    else if (strstr(positionString,"SS"))
   positions_held[SHORT] = 1;
    else if (strstr(positionString,"OF"))
   positions_held[OUTFIELD] = 1;
    else if (strstr(positionString,"DH"))
   positions_held[DES_HIT] = 1;

    /* Start the HTML page */
    fprintf(cgiOut, "<TITLE>Changing %s %s</title>", fname, lname);
    fprintf(cgiOut, "</head><body bgcolor=white>\n");
    fprintf(cgiOut, "<h2>Changing Player: %s %s</h2>\n", fname, lname);
    fprintf(cgiOut, "<p>\n");
    fprintf(cgiOut, "<FORM ACTION=\"change.cgi\" METHOD=POST>\n");
    fprintf(cgiOut, "<INPUT TYPE=HIDDEN NAME=\"id\" VALUE=\"%s\">\n", id);
    fprintf(cgiOut, "First Name (required): <INPUT SIZE=10 NAME=\"fname\" 
   VALUE=\"%s\">\n", fname);
    fprintf(cgiOut, "Last Name (required): <INPUT SIZE=10 NAME=\"lname\" 
   VALUE=\"%s\">\n", lname);
    fprintf(cgiOut, "<font size=-2>(Note: Middle names/initials should go 
   with the first name. Extensions like 'Jr.' or 'III' should go 
   with the last name.)</font><br>");
    fprintf(cgiOut, "Position:<br>\n");
    fprintf(cgiOut, "<SELECT MULTIPLE SIZE=5 NAME=\"position\">\n");
    for (i=0;i<8;i++) {
   fprintf(cgiOut, "<OPTION VALUE=\"%s\"", positions[i]);
   if (positions_held[i])
       fprintf(cgiOut, " SELECTED");
   fprintf(cgiOut, ">%s\n", position_names[i]);
    }
    fprintf(cgiOut, "</select><br> (Note: At least one position is 
   required.)\n");
    fprintf(cgiOut, "<br>\n");
    fprintf(cgiOut, "Year: <INPUT SIZE=5 NAME=\"year\" VALUE=\"%s\"><br>\n", 
      year);
    fprintf(cgiOut, 
           "Club: <INPUT SIZE=50 NAME=\"club\" VALUE=\"%s\"><br>\n", 
      club);
    fprintf(cgiOut, "Games played: <INPUT SIZE=5 NAME=\"G\" 
      VALUE=\"%s\"><br>\n", G);
    fprintf(cgiOut, "<p>\n");
    fprintf(cgiOut, "<TABLE BORDER>\n");
    fprintf(cgiOut, "<TR>\n<TH>Pitchers</th> <TH>Other 
   Players</th>\n</tr>\n<TR>\n");
    fprintf(cgiOut, "<TD>\n<TABLE BORDER=0>\n");

    if (positions_held[PITCHER]) {
   /* Set the pitcher data and null-out the non-pitcher data */
   /* All of the data must be defined since it will be printed on
   the form. */
   strcpy(W,msql_data[5]);
   strcpy(L,msql_data[6]);
   strcpy(IP,msql_data[7]);
   strcpy(RP,msql_data[8]);
   strcpy(ER,msql_data[9]);
   strcpy(SOP,msql_data[10]);
   strcpy(BBP,msql_data[11]);
   strcpy(GS,msql_data[12]);
   strcpy(CG,msql_data[13]);
   strcpy(SHO,msql_data[14]);
   strcpy(SV,msql_data[15]);
   strcpy(AB,"");
   strcpy(RB,"");
   strcpy(H,"");
   strcpy(B2,"");
   strcpy(B3,"");
   strcpy(HR,"");
   strcpy(RBI,"");
   strcpy(SB,"");
   strcpy(BBB,"");
   strcpy(SOB,"");
    } else {
   /* Do the reverse for the non-pitchers */
   strcpy(AB,msql_data[5]);
   strcpy(RB,msql_data[6]);
   strcpy(H,msql_data[7]);
   strcpy(B2,msql_data[8]);
   strcpy(B3,msql_data[9]);
   strcpy(HR,msql_data[10]);
   strcpy(RBI,msql_data[11]);
   strcpy(SB,msql_data[12]);
   strcpy(BBB,msql_data[13]);
   strcpy(SOB,msql_data[14]);
   strcpy(W,"");
   strcpy(L,"");
   strcpy(IP,"");
   strcpy(RP,"");
   strcpy(ER,"");
   strcpy(SOP,"");
   strcpy(BBP,"");
   strcpy(GS,"");
   strcpy(CG,"");
   strcpy(SHO,"");
   strcpy(SV,"");
    }

    /* Print the table with all of the values */
    fprintf(cgiOut, "<TR><TD>Wins: <INPUT SIZE=3 NAME=\"W\" 
   VALUE=\"%s\"></td>\n", W);
    fprintf(cgiOut, "<TD>Losses: <INPUT SIZE=3 NAME=\"L\"  
   VALUE=\"%s\"></td></tr>\n", L);
    fprintf(cgiOut, "<TR><TD>Innings Pitched:</td>\n<TD><INPUT SIZE=5 
   NAME=\"IP\" value=\"%s\"></td></tr>\n", IP);
    fprintf(cgiOut, "<TR><TD>Runs Allowed:</td>\n<TD><INPUT SIZE=5 
   NAME=\"RP\" VALUE=\"%s\"></td></tr>\n", RP);
    fprintf(cgiOut, 
           "<TR><TD>Earned Runs:</td>\n<TD><INPUT SIZE=5 NAME=\"ER\"  
   VALUE=\"%s\"></td></tr>\n", ER);
    fprintf(cgiOut, "<TR><TD>Strike Outs:</td>\n<TD><INPUT SIZE=5 
   NAME=\"SOP\" VALUE=\"%s\"></td></tr>\n", SOP);
    fprintf(cgiOut, "<TR><TD>Base on Balls (Walks):</td>\n<TD><INPUT SIZE=5 
   NAME=\"BBP\" VALUE=\"%s\"></td></tr>\n", BBP);
    fprintf(cgiOut, "<TR><TD>Games Started:</td>\n<TD><INPUT SIZE=5 
   NAME=\"GS\" VALUE=\"%s\"></td></tr>\n", GS);
    fprintf(cgiOut, "<TR><TD>Complete Games:</td>\n<TD><INPUT SIZE=5 
   NAME=\"CG\" VALUE=\"%s\"></td></tr>\n", CG);
    fprintf(cgiOut, "<TR><TD>Shutouts:</td>\n<TD><INPUT SIZE=5 NAME=\"SHO\" 
   value=\"%s\"></td></tr>\n", SHO);
    fprintf(cgiOut, "<TR><TD>Saves:</td>\n<TD><INPUT SIZE=5 NAME=\"SV\" 
   value=\"%s\"></td></tr>\n", SV);

    fprintf(cgiOut, "</table>\n</td>\n<TD>\n<TABLE BORDER=0>");

    fprintf(cgiOut, "<TR><TD>At Bats:</td>\n<TD><INPUT SIZE=5 NAME=\"AB\" 
      value=\"%s\"></td></tr>\n", AB);
    fprintf(cgiOut, 
           "<TR><TD>Runs Scored:</td>\n<TD><INPUT SIZE=5 NAME=\"RB\" 
      value=\"%s\"></td></tr>\n", RB);
    fprintf(cgiOut, "<TR><TD>Hits:</td>\n<TD><INPUT SIZE=5 NAME=\"H\" 
      value=\"%s\"></td></tr>\n", H);
    fprintf(cgiOut, "<TR><TD>Doubles:</td>\n<TD><INPUT SIZE=5 NAME=\"B2\" 
      value=\"%s\"></td></tr>\n", B2);
    fprintf(cgiOut, "<TR><TD>Triples:</td>\n<TD><INPUT SIZE=5 NAME=\"B3\" 
      value=\"%s\"></td></tr>\n", B3);
    fprintf(cgiOut, "<TR><TD>Home Runs:</td>\n<TD><INPUT SIZE=5 NAME=\"HR\" 
      value=\"%s\"></td></tr>\n", HR);
    fprintf(cgiOut, "<TR><TD>Runs Batted In:</td>\n<TD><INPUT SIZE=5 
   NAME=\"RBI\" value=\"%s\"></td></tr>\n", RBI);
    fprintf(cgiOut, "<TR><TD>Stolen Bases:</td>\n<TD><INPUT SIZE=5 
   NAME=\"SB\" value=\"%s\"></td></tr>\n", SB);
    fprintf(cgiOut, "<TR><TD>Base on Balls (Walks):</td>\n<TD><INPUT SIZE=5 
   NAME=\"BBB\" value=\"%s\"></td></tr>\n", BBB);
    fprintf(cgiOut, "<TR><TD>Strike Outs:</td>\n<TD><INPUT SIZE=5 
   NAME=\"SOB\" value=\"%s\"></td></tr>\n", SOB);

    fprintf(cgiOut, "</table>\n</td>\n</tr>\n</table>\n");
    fprintf(cgiOut, "<INPUT TYPE=SUBMIT VALUE=\"  Change Player Info  \"> 
   <INPUT TYPE=RESET>");
    fprintf(cgiOut, "</form>");

    msqlFreeResult(msql_out);

    return;
}

void Error(char *error) {
    fprintf(cgiOut, "<HTML><HEAD>\n");
    fprintf(cgiOut, "<TITLE>Error</title>\n");
    fprintf(cgiOut, "<BODY>\n");
    fprintf(cgiOut, "<H1>There was an error in your submission:</h1>\n");
    fprintf(cgiOut, "<p>%s", error);
    fprintf(cgiOut, "<p><a href=\"change.html\">Go</a> back and try again.");
    fprintf(cgiOut, "</body></html>\n");
    exit(0);
}

[AO1]I think you mean "indicate" rather than "signal". You could also mention that values are binary in the array.
