#include <stdio.h>
#include <cgic.h>
#include <time.h>
#include <msql.h>

#define PITCHER  0
#define CATCHER  1
#define FIRST_B  2
#define SECOND_B 3
#define THIRD_B  4
#define SHORT    5
#define OUTFIELD 6
#define DES_HIT  7

char *positions[] = {
    "P",
    "C",
    "B1",
    "B2",
    "B3",
    "SS",
    "OF",
    "DH"
};

/* The form values for the character fields 'Greater than', 'Less than',
and 'Exactly' are stored here as '>', '<' and '=', respectively.
*/
char *choices[] = {
    "<",
    "=",
    ">"
};

/* The user can choose and 'and' or 'or' search. Luckily, the words
'and' and 'or' are what mSQL expects as boolean operators, so we can also
use this array to paste the values into the query string.
*/
char *bool_types[] = {
    "and",
    "or"
};

       
char fname[51];
char lname[51];
char club[51];
char year[10];
int G, W, L, R, ER, SO, BB, GS, CG, SHO, SV, AB, H, B2, B3, HR,
    RBI, SB;
double IP;

void Error(char *);
void CreateQuery(char *);
void HandleYear(char *, int, int); /* Parse the year information */
void PerformQuery(char *);

int cgiMain() {
    char query[512] = "";

    cgiHeaderContentType("text/html");
    
    CreateQuery(query);

    fprintf(cgiOut, "<html><head>");
    fprintf(cgiOut, "<title>Baseball Database Search Results</title>");
    fprintf(cgiOut, "<body>");
    /* PerformQuery() actually prints out the HTML this time, so it's 
    embedded within the fprintf() calls. */  
    PerformQuery(query);
    fprintf(cgiOut, "</body></html>\n");

    return 0;
}

void CreateQuery(char *query) {
    int positionsChosen[8];
    int result, invalid, i, choice, length, b_length, bool_type;
    /* 'choice' contains the 'greater than/less than/equal' choice for
    each numerical field.

    'length' is the length of the query string, while 'b_length'[SKS1][AO2] is the length of
    boolean operator chosen. These are used to remove the last boolean
    operator from the query string[AO3][SKS4].

    'bool_type' contains the boolean operator chosen
    */

       char dummy[512]; /* A dummy string long enough to hold the entire query 
                        */
    char positionString[256] = "";
    char yearString[50] = ""; /* A string to hold the year portion of the 
             query */

    /* We want to select the first name and last name of the matching 
       players. We want 'DISTINCT' because we don't care about individual 
       years. 
    */
    strcat(query,"Select DISTINCT fname, lname from baseball");

    /* Check to see if the 'all' button was chosen. If so, quit now
       and the query will select all the distinct names 
    */
    result = cgiFormStringNoNewlines("all", dummy, 20);
    if (result == cgiFormSuccess)
   return;

    /* Since the 'all' button wasn't chosen we can safely add 'where' to the 
       query.
    */
    strcat(query," where");

    /* Retrieve the bool_type from the form. Since it's a menu on the form, 
       one value should always be chosen. If it's not, something is wrong. 
    */
    result = cgiFormSelectSingle("bool_type", bool_types, 2, &bool_type, 0);
    if ((result == cgiFormNotFound) || (result == cgiFormEmpty))
   Error("Invalid form");

    result = cgiFormStringNoNewlines("fname",fname,51);
    if (result == cgiFormTruncated)
   Error("Names cannot be longer than 50 characters.");

    result = cgiFormStringNoNewlines("lname",lname,51);
    if (result == cgiFormTruncated)
   Error("Names cannot be longer than 50 characters.");

    result = cgiFormStringNoNewlines("club",club,51);
    if (result == cgiFormTruncated)
   Error("Club names cannot be longer than 50 characters.");

    result = cgiFormCheckboxMultiple("position",positions,8,
   positionsChosen, &invalid);
    if (invalid)
   Error("Invalid form data was submitted");
    for (i = 0; i < 8; i++) {
   /* This creates a string to hold the position portion of the
      query. For each positionsChosen that is position (i.e. chosen),
      we add the string "position like '%DH%' and" (for example). 
   */
      /* NOTE: Since both sprintf and strcat interpolate the '%' 
         character, we need to escape it twice. This will happen with
         all strings like this. 
      */
   if (positionsChosen[i]) {
       sprintf(dummy," position like '%%%%%s%%%%' %s", 
      positions[i],  bool_types[bool_type]);
       strcat(positionString, dummy);
   }
    }

    result = cgiFormStringNoNewlines("year",year,10);
    if (result == cgiFormSuccess) {
   /* 'Gyear' hold the 'greater than/less than/equal to' choice for
      the 'year' field. A similar 'G' variable will be present for all
      numerical fields 
   */
   result = cgiFormSelectSingle("Gyear",choices,3,&choice,0);
   if ((result == cgiFormNotFound) || (result == cgiFormEmpty))
       Error("Invalid form");
   /* The choice given by 'Gyear', the bool_type for the entire 
      form, and a string to hold the result information is passed to
      HandleYear to create the year portion of the query
   */
   HandleYear(yearString, bool_type, choice);
    }

    result = cgiFormIntegerBounded("G",&G,0,999,0);
    if (result == cgiFormConstrained)
   Error("One of the numeric form values was either less
than zero or unreasonably large: G");

    if (positionsChosen[PITCHER]) {
   result = cgiFormIntegerBounded("W",&W,0,99,0);
   if (result == cgiFormConstrained)
       Error("One of the numeric form values was either less
than zero or unreasonably large: W");
   result = cgiFormIntegerBounded("L",&L,0,99,0);
   if (result == cgiFormConstrained)
       Error("One of the numeric form values was either less
than zero or unreasonably large: L");
   result = cgiFormDoubleBounded("IP",&IP,0.0,999.0,0.0);
   if (result == cgiFormConstrained)
       Error("One of the numeric form values was either less
than zero or unreasonably large: IP");
   result = cgiFormIntegerBounded("RP",&R,0,999,0);
   if (result == cgiFormConstrained)
       Error("One of the numeric form values was either less
than zero or unreasonably large: R");
   result = cgiFormIntegerBounded("ER",&ER,0,999,0);
   if (result == cgiFormConstrained)
       Error("One of the numeric form values was either less
than zero or unreasonably large: ER");
   result = cgiFormIntegerBounded("SOP",&SO,0,999,0);
   if (result == cgiFormConstrained)
       Error("One of the numeric form values was either less
than zero or unreasonably large: SO");
   result = cgiFormIntegerBounded("BBP",&BB,0,999,0);
   if (result == cgiFormConstrained)
       Error("One of the numeric form values was either less
than zero or unreasonably large: BB");
   result = cgiFormIntegerBounded("GS",&GS,0,99,0);
   if (result == cgiFormConstrained)
       Error("One of the numeric form values was either less
than zero or unreasonably large: GS");
   result = cgiFormIntegerBounded("CG",&CG,0,99,0);
   if (result == cgiFormConstrained)
       Error("One of the numeric form values was either less
than zero or unreasonably large: CG");
   result = cgiFormIntegerBounded("SHO",&SHO,0,99,0);
   if (result == cgiFormConstrained)
       Error("One of the numeric form values was either less
than zero or unreasonably large: SHO");
   result = cgiFormIntegerBounded("SV",&SV,0,99,0);
   if (result == cgiFormConstrained)
       Error("One of the numeric form values was either less
than zero or unreasonably large: SV");

   /* Now we can start building the query. Since any field may or 
      may not be there, we have to have a lot of 'if's 
   */
   if (fname[0]) {
       sprintf(dummy," fname clike '%%%%%s%%%%' %s", fname, 
      bool_types[bool_type]);
       strcat(query,dummy);
   }
   if (lname[0]) {
       sprintf(dummy," lname clike '%%%%%s%%%%' %s", lname, 
      bool_types[bool_type]);
       strcat(query,dummy);
   }
   if (club[0]) {
       sprintf(dummy," club clike '%%%%%s%%%%' %s", club, 
      bool_types[bool_type]);
       strcat(query,dummy);
   }
   if (positionString[0]) {
       strcat(query,positionString);
   }
   if (yearString[0]) {
       strcat(query,yearString);
   }
   if (G) {
       result = cgiFormSelectSingle("GG",choices,3,&choice,0);
       if ((result == cgiFormNotFound) || 
      (result == cgiFormEmpty))
      Error("Invalid form");
        /* This part of the string is created by putting 
      together the field name 'G', the value of the choice 
      ('<', '=' or '>') the actual number entered by the user 
      and the bool_type ('and' or 'or'). This is the same 
      method used for all of the numerical data.
       */
       sprintf(dummy," G %s %d %s", choices[choice], G, 
         bool_types[bool_type]);
       strcat(query,dummy);
   }
   if (W) {
       result = cgiFormSelectSingle("GW",choices,3,&choice,0);
       if ((result == cgiFormNotFound) || 
      (result == cgiFormEmpty))
      Error("Invalid form");
       sprintf(dummy," W %s %d %s", choices[choice], W, 
         bool_types[bool_type]);
       strcat(query,dummy);
   }
   if (L) {
       result = cgiFormSelectSingle("GL",choices,3,&choice,0);
       if ((result == cgiFormNotFound) || 
      (result == cgiFormEmpty))
      Error("Invalid form");
       sprintf(dummy," L %s %d %s", choices[choice]choices[choice], L, 
         bool_types[bool_type]);
       strcat(query,dummy);
   }
   if (IP) {
       result = cgiFormSelectSingle("GIP",choices,3,&choice,0);
       if ((result == cgiFormNotFound) || 
      (result == cgiFormEmpty))
      Error("Invalid form");
       sprintf(dummy," IP %s %3.1f %s", choices[choice]choices[choice], 
      IP, bool_types[bool_type]);
       strcat(query,dummy);
   }
   if (R) {
       result = cgiFormSelectSingle("GRP",choices,3,&choice,0);
       if ((result == cgiFormNotFound) || 
      (result == cgiFormEmpty))
      Error("Invalid form");
       sprintf(dummy," R %s %d %s", choices[choice]choices[choice], R, 
         bool_types[bool_type]);
       strcat(query,dummy);
   }
   if (ER) {
       result = cgiFormSelectSingle("GER",choices,3,&choice,0);
       if ((result == cgiFormNotFound) || 
      (result == cgiFormEmpty))
      Error("Invalid form");
       sprintf(dummy," ER %s %d %s", choices[choice], 
      ER, bool_types[bool_type]);
       strcat(query,dummy);
   }
   if (SO) {
       result = cgiFormSelectSingle("GSOP",choices,3,&choice,
      0);
       if ((result == cgiFormNotFound) || 
      (result == cgiFormEmpty))
      Error("Invalid form");
       sprintf(dummy," SO %s %d %s", choices[choice], 
      SO, bool_types[bool_type]);
       strcat(query,dummy);
   }
   if (BB) {
       result = cgiFormSelectSingle("GBBP",choices,3,&choice,
      0);
       if ((result == cgiFormNotFound) || 
      (result == cgiFormEmpty))
      Error("Invalid form");
       sprintf(dummy," BB %s %d %s", choices[choice], 
      BB, bool_types[bool_type]);
       strcat(query,dummy);
   }
   if (GS) {
       result = cgiFormSelectSingle("GGS",choices,3,&choice,0);
       if ((result == cgiFormNotFound) || 
      (result == cgiFormEmpty))
      Error("Invalid form");
       sprintf(dummy," GS %s %d %s", choices[choice], 
      GS, bool_types[bool_type]);
       strcat(query,dummy);
   }
   if (CG) {
       result = cgiFormSelectSingle("GCG",choices,3,&choice,0);
       if ((result == cgiFormNotFound) || 
      (result == cgiFormEmpty))
      Error("Invalid form");
       sprintf(dummy," CG %s %d %s", choices[choice], 
      CG, bool_types[bool_type]);
       strcat(query,dummy);
   }
   if (SHO) {
       result = cgiFormSelectSingle("GSHO",choices,3,&choice,
      0);
       if ((result == cgiFormNotFound) || 
      (result == cgiFormEmpty))
      Error("Invalid form");
       sprintf(dummy," SHO %s %d %s", choices[choice], 
      SHO, bool_types[bool_type]);
       strcat(query,dummy);
   }
   if (SV) {
       result = cgiFormSelectSingle("GSV",choices,3,&choice,0);
       if ((result == cgiFormNotFound) || 
      (result == cgiFormEmpty))
      Error("Invalid form");
       sprintf(dummy," SV %s %d %s", choices[choice], 
      SV, bool_types[bool_type]);
       strcat(query,dummy);
   }

   /* The last few characters of the query (2 or 3 depending on whether
      the bool_type is 'or' or 'and') are chopped off. This is because 
      the query built by stringing together pieces like '(G < 43) and',
      leaving a trailing 'and' or 'or' at the end of the query.
   */
   length = strlen(query);
   b_length = strlen(bool_types[bool_type]);
   for(i = length-b_length ; i <= length ; i++) {
       query[i] = 0;
   }
    } else {
   /* Now repeat everything for the non-pitchers */
   result = cgiFormIntegerBounded("AB",&AB,0,999,0);
   if (result == cgiFormConstrained)
       Error("One of the numeric form values was either less
than zero or unreasonably large: AB");
   result = cgiFormIntegerBounded("RB",&R,0,999,0);
   if (result == cgiFormConstrained)
       Error("One of the numeric form values was either less
than zero or unreasonably large: R");
   result = cgiFormIntegerBounded("H",&H,0,999,0);
   if (result == cgiFormConstrained)
       Error("One of the numeric form values was either less
than zero or unreasonably large: H");
   result = cgiFormIntegerBounded("B2",&B2,0,999,0);
   if (result == cgiFormConstrained)
       Error("One of the numeric form values was either less
than zero or unreasonably large: 2B");
   result = cgiFormIntegerBounded("B3",&B3,0,99,0);
   if (result == cgiFormConstrained)
       Error("One of the numeric form values was either less
than zero or unreasonably large: 3B");
   result = cgiFormIntegerBounded("HR",&HR,0,99,0);
   if (result == cgiFormConstrained)
       Error("One of the numeric form values was either less
than zero or unreasonably large: HR");
   result = cgiFormIntegerBounded("RBI",&RBI,0,999,0);
   if (result == cgiFormConstrained)
       Error("One of the numeric form values was either less
than zero or unreasonably large: RBI");
   result = cgiFormIntegerBounded("SB",&SB,0,999,0);
   if (result == cgiFormConstrained)
       Error("One of the numeric form values was either less
than zero or unreasonably large: SB");
   result = cgiFormIntegerBounded("BBB",&BB,0,999,0);
   if (result == cgiFormConstrained)
       Error("One of the numeric form values was either less
than zero or unreasonably large: BB");
   result = cgiFormIntegerBounded("SOB",&SO,0,999,0);
   if (result == cgiFormConstrained)
       Error("One of the numeric form values was either less
than zero or unreasonably large: SO");

   if (fname[0]) {
       sprintf(dummy," fname clike '%%%%%s%%%%' %s", fname, 
      bool_types[bool_type]); 
       strcat(query,dummy);
   }
   if (lname[0]) {
       sprintf(dummy," lname clike '%%%%%s%%%%' %s", 
      lname, bool_types[bool_type]);
       strcat(query,dummy);
   }
   if (club[0]) {
       sprintf(dummy," club clike '%%%%%s%%%%' %s", 
      club, bool_types[bool_type]);
       strcat(query,dummy);
   }
   if (positionString[0]) {
       strcat(query,positionString);
   }
   if (yearString[0]) {
       strcat(query,yearString);
   }
   if (G) {
       result = cgiFormSelectSingle("GG",choices,3,&choice,0);
       if ((result == cgiFormNotFound) || 
      (result == cgiFormEmpty))
      Error("Invalid form");
       sprintf(dummy," G %s %d %s", choices[choice], G, 
      bool_types[bool_type]);
       strcat(query,dummy);
   }
   if (AB) {
       result = cgiFormSelectSingle("GAB",choices,3,&choice,0);
       if ((result == cgiFormNotFound) || 
      (result == cgiFormEmpty))
      Error("Invalid form");
       sprintf(dummy," AB %s %d %s", choices[choice], AB, 
      bool_types[bool_type]);
       strcat(query,dummy);
   }
   if (R) {
       result = cgiFormSelectSingle("GRB",choices,3,&choice,0);
       if ((result == cgiFormNotFound) || 
      (result == cgiFormEmpty))
      Error("Invalid form");
       sprintf(dummy," R %s %d %s", choices[choice], R, 
      bool_types[bool_type]);
       strcat(query,dummy);
   }
   if (H) {
       result = cgiFormSelectSingle("GH",choices,3,&choice,0);
       if ((result == cgiFormNotFound) || 
      (result == cgiFormEmpty))
      Error("Invalid form");
       sprintf(dummy," H %s %d %s", choices[choice], 
      H, bool_types[bool_type]);
       strcat(query,dummy);
   }
   if (B2) {
       result = cgiFormSelectSingle("GB2",choices,3,&choice,0);
       if ((result == cgiFormNotFound) || 
      (result == cgiFormEmpty))
      Error("Invalid form");
       sprintf(dummy," B2 %s %d %s", choices[choice], B2, 
      bool_types[bool_type]);
       strcat(query,dummy);
   }
   if (B3) {
       result = cgiFormSelectSingle("GB3",choices,3,&choice,0);
       if ((result == cgiFormNotFound) || 
      (result == cgiFormEmpty))
      Error("Invalid form");
       sprintf(dummy," B3 %s %d %s", choices[choice], 
      B3, bool_types[bool_type]);
       strcat(query,dummy);
   }
   if (HR) {
       result = cgiFormSelectSingle("GHR",choices,3,&choice,
      0);
       if ((result == cgiFormNotFound) || 
      (result == cgiFormEmpty))
      Error("Invalid form");
       sprintf(dummy," HR %s %d %s", choices[choice], 
      HR, bool_types[bool_type]);
       strcat(query,dummy);
   }
   if (RBI) {
       result = cgiFormSelectSingle("GRBI",choices,3,&choice,
      0);
       if ((result == cgiFormNotFound) || 
      (result == cgiFormEmpty))
      Error("Invalid form");
       sprintf(dummy," RBI %s %d %s", choices[choice], 
      RBI, bool_types[bool_type]);
       strcat(query,dummy);
   }
   if (SB) {
       result = cgiFormSelectSingle("GSB",choices,3,&choice,0);
       if ((result == cgiFormNotFound) || 
      (result == cgiFormEmpty))
      Error("Invalid form");
       sprintf(dummy," SB %s %d %s", choices[choice], 
      SB, bool_types[bool_type]);
       strcat(query,dummy);
   }
   if (BB) {
       result = cgiFormSelectSingle("GBBB",choices,3,&choice,
      0);
       if ((result == cgiFormNotFound) || 
      (result == cgiFormEmpty))
      Error("Invalid form");
       sprintf(dummy," BB %s %d %s", choices[choice], 
      BB, bool_types[bool_type]);
       strcat(query,dummy);
   }
   if (SO) {
       result = cgiFormSelectSingle("GSOB",choices,3,&choice,
      0);
       if ((result == cgiFormNotFound) || 
      (result == cgiFormEmpty))
      Error("Invalid form");
       sprintf(dummy," SO %s %d %s", choices[choice], 
      SO, bool_types[bool_type]);
       strcat(query,dummy);
   }

   length = strlen(query);
   b_length = strlen(bool_types[bool_type]);
   for(i = length-b_length ; i <= length ; i++) {
       query[i] = 0;
   }
    }
    return;
}

void PerformQuery(char *query) {
    int i;

    /* mSQL variables */
    m_result *msql_out;
    m_row msql_data;
    int dbh = 0;
    int msql_result = 0;

    char dummy[512];
    char enc_fname[51]; /* Holds slightly encoded versions of fname... */
    char enc_lname[51]; /* ...and lname */

    dbh = msqlConnect(NULL);
    if (dbh == -1)
   Error("Database Error: Could not connect to mSQL server");

    msql_result = msqlSelectDB(dbh,"test");
    if (msql_result == -1) {
   msqlClose(dbh);
   Error("Database Error: Could not select database");
    }

    /* Send off the query */
    msql_result = msqlQuery(dbh,query);
    if (msql_result == -1) {
   msqlClose(dbh);
   sprintf(dummy, "Database Error: Select Query not successful:
       %s :: %s", msqlErrMsg, query);
   Error(dummy);
    }

    /* msql_result holds the number of rows returned by the select. If it
    is '0' then no players matched. Print a nice 'sorry' page and leave.
    */
    if (msql_result == 0) {
   msqlClose(dbh);
   fprintf(cgiOut, "<h1>Sorry</h1>");
   fprintf(cgiOut, "<p>No players matched your criteria");
   fprintf(cgiOut, "<p><A HREF=\".\">Search</a> again.");
   return;
    }

    /* Store the result. After this point, we *must* call msqlFreeResult()
    before any exit point */
    msql_out = msqlStoreResult();
    /* Let the user know how many matches there are. */
    fprintf(cgiOut, "<h1>%d successful matches!</h1>", msql_result);
    fprintf(cgiOut, "<p><UL>\n");
    /* Go through each of the result rows */
    while (msql_data = msqlFetchRow(msql_out)) {
   /* Encode the first name so that spaces are '+'s.
   This is necessary since the name is going to be
   put into a URL. */
   for (i=0;i<(signed)strlen(msql_data[0]);i++) {
       if (msql_data[0][i] == ' ')
      enc_fname[i] = '+';
       else
      enc_fname[i] = msql_data[0][i];
   }
   enc_fname[i] = 0;

   for (i=0;i<(signed)strlen(msql_data[1]);i++) {
       if (msql_data[1][i] == ' ')
      enc_lname[i] = '+';
       else
      enc_lname[i] = msql_data[1][i];
   }
   enc_lname[i] = 0;

   /* Print the player's name as a link the show_player.cgi */
   fprintf(cgiOut, 
    "<LI><A HREF=\"show_player.cgi?fname=%s&lname=%s\">%s %s</a>\n",
       enc_fname, enc_lname, msql_data[0],
       msql_data[1]);
    }
    /* End the list and leave */
    fprintf(cgiOut, "</ul>\n");
    fprintf(cgiOut, "<p><A HREF=\".\">Search</a> again.");
    msqlFreeResult(msql_out);
    return;
}


void Error(char *error) {
    fprintf(cgiOut, "<HTML><HEAD>\n");
    fprintf(cgiOut, "<TITLE>Error</title>\n");
    fprintf(cgiOut, "<BODY>\n");
    fprintf(cgiOut, "<H1>There was an error in your submission:</h1>\n");
    fprintf(cgiOut, "<p>%s", error);
    fprintf(cgiOut, "<p><a href=\"search.html\">Go</a> back and try again.");
    fprintf(cgiOut, "</body></html>\n");
    exit(0);
}

/* Create the year portion of the query string. */
void HandleYear[SKS5][AO6](char *yearStr, int bool_type, int choice)
    {

    /* In the form, years are allowed to be given as a range.
       (e.g. 1990-1995). If there is only one year given, this function
       returns something like '(year like 1945)'. If two years are
       given, they are separated and an appropriate string is generated
       based on the 'choice' selected by the user ('less than', 'greater 
       than', or 'exactly'). Sensible things are done for odd submissions 
       like 'greater than 1950-1960'.
    */

    /* These are all numerical values of the year string */
    int num_year, num_year1, num_year2;
    
    /* These hold the two separate years, if two are given */
    char *year1;
    char *year2;
    [AO7]
    char dummy[50] = "";

    /* If there is no '-', only one year is given */
    if (!strchr(year,'-')) {
   /* Turn it into an integer */
   num_year = atoi(year);
   if (! num_year)
       Error("The year must be a numeric value");
   if (num_year < 1800)
       num_year += 1900;
   if (num_year < 1850)
       Error("The year entered is not a reasonable value");
   /* Create the query and leave */
   sprintf(dummy," year %s %d %s", choices[choice], num_year, 
       bool_types[bool_type]);
   strncpy[AO8](yearStr,dummy,50);
   return;
    }[SKS9][AO10]
    /* Use strtok() to get the individual years */
    year1 = (char *)strtok(year,"-");
    year2 = (char *)strtok(NULL,"-");
    /* Turn them into integers */
    num_year1 = atoi(year1);
    num_year2 = atoi(year2);
    if (!num_year1 || !num_year2)
   Error("Year ranges must be of one these formats: ####-####, 
        ##-##, ####-## or ##-####");
    if (num_year1 < 1800)
   num_year1 += 1900;
    if (num_year2 < 1800)
   num_year2 += 1900;
    if ((num_year1 < 1850) || (num_year2 < 1850))
   Error("One of the years entered is not a reasonable value");
    /* If they chose 'greater than', go greater than the larger year. */
    if (choice == 2)
   sprintf(dummy," year > %d %s", num_year2, bool_types[bool_type]);
    /* If they chose 'less then' go less than the smaller year. */
    else if (choice == 0)
   sprintf(dummy," year < %d %s", num_year1, bool_types[bool_type]);
    /* If they chose 'exactly', go between the two years, inclusive. */
    else
   sprintf(dummy," (year >= %d and year <= %d) %s",
       num_year1, num_year2, bool_types[bool_type]);
    strcat(yearStr,dummy);
    return;
}

[SKS1]Yes, Word is doing this automatically. One of the many reason I prefer Emacs, or even pico. :)
[AO2]Since this is part of code, try to make sure to use straight quotes. Did Word plug in slanted quotes when you read in the code?
[AO3]I don't understand why this is necessary -- why there's an extra trailing operator.
[SKS4]I tried to explain it in a comment on . Let me know if I wasn't clear.
[SKS5]It's only used in two of the programs. It was kind of annoying actually, a lot of the functions would only show up in two of the programs, or would be slightly different each time. I wanted a library, believe me! :)
[AO6]You use this function over and over -- it's the same each time, right? I imagine it doesn't have to be typed into every program separately; it could be in a library they all share.
[AO7]This line looks like it's in the wrong place -- it should go above the declaration of year1
[AO8]As before, why not use strcpy?
[SKS9]'greater than 1950' works, at least it should. The sprintf includes 'year', the choice from the form (which could be '<', '=' or '<', and the year.
[AO10]It appears that you don't allow queries like "greater than 1950" -- that is, if a single year is submitted, no > or < can be included.
