#!/usr/bin/perl -w

use CGI;

umask 0;
open(F,"/usr/dict/words") or die("Can't open! $!");
chdir("users") or die("Can't chdir! $!");
# This is the directory where all of the user information will
# be stored.

$output = new CGI;

if (not $output->param) {
        print $output->header, $output->start_html('My Dictionary');
        print <<HTML;
        <FORM ACTION="read2.cgi" METHOD=POST>
        <p>Enter your username: 
                <INPUT NAME="username" SIZE=30>
        <p>
        </form></body></html>
HTML
        exit(0);
}

$user = $output->param('username');

## If a file for the user does not exist, create one and set the
## Starting value to '0'.
if ( not -e "$user" ) {
        open (U, ">$user") or die("Can't open! $!");
        print U "0\n";
        close U;
        &print_range('0');

## Else, if the user does exist, and the URL didn't specify
## a starting value, read the users last value and start there.
} elsif ( not $output->param('start') ) {
        open(U,"$user") or die("Can't open user! $!");
        $start = <U>; close U;
        chomp $start;
        &print_range($start);

## Else, if the user does exist, and the URL did specify
## a starting value, write the starting value to the user's
## file and then start printing.
} else {
        open(U,">$user") or die("Can't open user to write! $!");
        print U $output->param('start'), "\n";
        close U;
        &print_range($output->param('start'));
}

sub print_range {
        my $start = shift;
        my $count = 0;
        my $line = "";
        print $output->header, $output->start_html('My Dictionary');
        print "<pre>\n";
        while (($count < $start) and ($line = <F>)) { $count++; }
        while (($count < $start+10) and ($line = <F>) ) 
                { print $line; $count++; }
        my $newnext = $start+10;
        my $newprev = $start-10;
        print "</pre><p>";
        unless ($start == 0) { 
                print
qq%<a href="read2.cgi?start=$newprev&username=$user">Previous</a>%;
        }
        unless (eof) {
                print 
qq% <a href="read2.cgi?start=$newnext&username=$user">Next</a>%;
        # Note that the 'username' has been added to the URL.
        # Otherwise the CGI would forget which user it was dealing with.
        }
        print $output->end_html;
        exit(0);
}
