/* cgihtmltest.c - A generic CGI program to print out the keys and values
	of the submitted form data.
*/

#include <stdio.h>
#include "cgi-lib.h"  /* This contains all of the definitions for the CGI 
                      functions */
#include "html-lib.h" /* This contains all of the definitions for the HTML
                      helper functions */

void print_all(llist l)
/* This functions prints out all of the data submitted by the form in the
same format as the above Perl example. Cgihtml also provides a built-in
function, print_entries(), which does the exact same thing using a set
HTML definition list format.
*/
{
  node* window; 
/* The 'node' type is defined by the cgihtml library and refers to the 
linked list which stores all of the form data. */

  window = l.head; 
/* This sets a pointer at the beginning of the form data */

  while (window != NULL) {
/* Go through the linked list until you reach the last (the first empty) entry */

    printf("  %s:%s<br>\n",window->entry.name,
        replace_ltgt(window->entry.value));
/* Print out the data. Replace_ltgt() is a provided function which HTML encodes
the text so that it will show up correctly on the client browser. */

    window = window->next;
/* Go to the next entry in the list. */

  }
}


int main()
{
  llist entries; /* This is a pointer to the parsed data */
  int status; /* This is a status integer provided by the library */

  html_header(); 
/* This is an HTML-helper function which prints the HTML header */

  html_begin("cgihtml test");
/* This is an HTML-helper function which prints the beginning of the HTML
page with the specified title. */

  status = read_cgi_input(&entries);
/* This reads in and parses the form data */
  printf("<p>Form information:<br>");
  print_all(entries);
/* Call the print_all() function defined above. */
  html_end();
/* This is an HTML-helper function which prints the end of the HTML page. */
  list_clear(&entries);
/* This frees the memory used by the form data. */
  return 0;
}
