#!/bin/sh

# This script is from page 74 of the book.

# Retrieve the process ID of the database daemon
# This is for a default mSQL 2 installation, for mSQL 1
# the line should be:
# PID=`cat /usr/local/Minerva/msqld.pid`
PID=`cat /usr/local/Hughes/msql2d.pid`

# This checks to see if the server process is running.
# Use this line for BSD systems
ALIVE=`ps aux | grep $PID | grep -v grep | awk '{print $2}'`
# Use this line for SYSV systems (Solaris, Linux)
#ALIVE=`ps -ef | grep $PID | grep -v grep | awk '{print $2}'`

if [ $ALIVE ]
then
	REALLY_ALIVE=`msqladmin version`
	DATE=`date`

	# If the first word of the result is 'ERROR', or if
	# there was no output at all, the msqladmin
	# program was not able to connect to the database server
	if ! echo $REALLY_ALIVE | grep "^ERROR"
	then
		exit
	fi
	if [ ! $REALLY_ALIVE ]
	then exit; fi
else
	# This should be /usr/local/Minerva/bin/msql &
	# for mSQL 1 installations
msql -s "mSQL daemon restarted" root@yourmachine.com <<EOM
The mSQL daemon died unexpectedly and was restarted
on $DATE.

Sincerely,
The mSQL Watchdog
EOM

fi
