#include <sys/time.h>
#include <stdio.h>
#include <mysql.h>

void main(char **args) {
    MYSQL_RES *result;
    MYSQL_ROW row;
    MYSQL *connection, mysql;
    int state;
    
    /* connect to the mySQL database at athens.imaginary.com */
    connection = mysql_connect(&mysql, "athens.imaginary.com", 0, 0);
    /* check for a connection error */
    if( connection == NULL ) {
        /* print the error message stored in MsqlErrMsg */
        printf(mysql_error(&mysql));
        exit(-1);
    }
    /* select which database to use on the server */
    state = mysql_select_db(connection, "db_test");
    /* again, -1 means an error */
    if( state == -1 ) {
        printf(mysql_error(connection));
        /* close up our connection before exiting */
        mysql_close(connection);
        exit(-1);
    }
    state = mysql_query(connection, "SELECT test_id, test_val FROM test");
    if( state == -1 ) {
        printf(mysql_error(connection));
        exit(-1);
    }
    /* must call mysql_store_result() before we can issue any
     * other Query() calls
     */  
    result = mysql_store_result(connection);
    printf("Rows: %d\n", mysql_num_rows(result));
    /* process each row in the result set */
    while( ( row = mysql_fetch_row(result)) != NULL ) {
        printf("id: %s, val: %s\n", row[0], row[1]);
    }
    /* free the result set */
    mysql_free_result(result);
    /* close the connection */
    mysql_close(connection);
    printf("Done.\n");
}
