#include <sys/time.h>
#include <stdio.h>
#include <msql.h>

void main(char **args) {
    int connection, state;
    m_result *result;
    m_row row;

    /* connect to the mSQL database at athens.imaginary.com */
    state = msqlConnect("athens.imaginary.com");
    /* check for a connection error */
    if( state == -1 ) {
        /* print the error message stored in MsqlErrMsg */
        printf(msqlErrMsg);
        exit(-1);
    }
    else {
        /* the return balue from msqlConnect() is our connection handle */
        connection = state;
    }
    /* select which database to use on the server */
    state = msqlSelectDB(connection, "db_test");
    /* again, -1 means an error */
    if( state == -1 ) {
        printf(msqlErrMsg);
        /* close up our connection before exiting */
        msqlClose(connection);
        exit(-1);
    }
    state = msqlQuery(connection, "SELECT test_id, test_val FROM test");
    if( state == -1 ) {
        printf(msqlErrMsg);
        exit(-1);
    }
    else {
        printf("Rows: %d\n", state);
    }
    /* must call msqlStoreResult() before we can issue any
     * other Query() calls
     */  
    result = msqlStoreResult();
    /* process each row in the result set */
    while( ( row = msqlFetchRow(result)) != NULL ) {
        printf("id: %s, val: %s\n", row[0], row[1]);
    }
    /* free the result set */
    msqlFreeResult(result);
    /* close the connection */
    msqlClose(connection);
    printf("Done.\n");
}
