#include <malloc.h>

#include "row.h"

Row::Row(m_result *res, m_row row) {
    fields = row;
    result = res;
}

Row::~Row() {
    if( fields != (m_row)NULL ) {
	Close();
    }
}

int Row::GetFieldCount() {
    if( fields == (m_row)NULL ) {
	throw "Row closed.";
    }
    return msqlNumFields(result);
}

char *Row::GetField(int field) {
    if( fields == (m_row)NULL ) {
	throw "Row closed.";
    }
    if( field < 1 || field > GetFieldCount() ) {
	throw "Field index out of bounds.";
    }
    return fields[field-1];
}

void Row::Close() {
    if( fields == (m_row)NULL ) {
	throw "Row closed.";
    }
    fields = (m_row)NULL;
    result = (m_result *)NULL;
}
