#include <stdio.h>

#include "connection.h"

void main(char **args) {
    Connection *connection;
    Result *result;
    
    try {
	connection = new Connection("athens.imaginary.com", "db_test");
	result = connection->Query("SELECT * from test");
	if( result != (Result *)NULL ) {
	    printf("Rows: %d\n", result->GetRowCount());
	    while( result->Next() ) {
		Row *row = result->GetCurrentRow();
		
		printf("id: %s, val: %s\n", row->GetField(1), row->GetField(2));
		row->Close();
		delete row;
	    }
	    result->Close();
	    delete result;
	}
	else {
	    printf("%d rows affected.\n", connection->GetAffectedRows());
	}
	connection->Close();
	delete connection;
	printf("Done.\n");
    }
    catch( char *err ) {
	printf("Error: %s\n", err);
	exit(-1);
    }
}
