#include "result.h"

Result::Result(T_RESULT *r) {
    result = r;
    row_count = -1; // only get it if it is requested
}

Result::~Result() {
    if( result != (T_RESULT *)NULL ) {
	Close();
    }
}

void Result::Close() {
    if( result == (T_RESULT *)NULL ) {
	return;
    }
#if defined(HAS_MSQL)    
    msqlFreeResult(result);
#elif defined(HAS_MYSQL)    
    mysql_free_result(result);
#else
    #error No database linked.
#endif    
    result = (T_RESULT *)NULL;
}

Row *Result::GetCurrentRow() {
    if( result == (T_RESULT *)NULL ) {
	throw "Result set closed.";
    }
    return current_row;
}

int Result::GetRowCount() {
    if( result == (T_RESULT *)NULL ) {
	throw "Result set closed.";
    }
    if( row_count > -1 ) {
	return row_count;
    }
    else {
#if defined(HAS_MSQL)
	row_count = msqlNumRows(result);
#elif defined(HAS_MYSQL)    
	row_count = mysql_num_rows(result);
#else
	#error No database linked.
#endif	
	return row_count;
    }
}

int Result::Next() {
    T_ROW row;
    
    if( result == (T_RESULT *)NULL ) {
	throw "Result set closed.";
    }
#if defined(HAS_MSQL)    
    row = msqlFetchRow(result);
#elif defined(HAS_MYSQL)
    row = mysql_fetch_row(result);
#else
    #error No database linked.
#endif    
    if( !row ) {
	current_row = (Row *)NULL;
	return 0;
    }
    else {
	current_row = new Row(result, row);
	return 1;
    }
}
	
