#!/usr/bin/perl -w

# This is the complete version of the script covered in part on page 166 of the book.

###
#Start
###
use strict;

# The my_end.pl library provides one function: end(), which
# prints an HTML error screen containing the error message provided, then
# die()'s.
require my_end;

# Load the Msql.pm module, connect to the server and select the 'teach'
# database, which contains all of our tables.
use Msql;
my $dbh = Msql->connect;
$dbh->selectdb("teach");

use CGI qw(:standard);
my $output = new CGI;
use_named_parameters(1);

# Each of the different parts of the script is selected via the 'action'
# parameter. If no 'action' is supplied, the default() function is called.
# Otherwise the appropriate function is called.
&default if not param('action');
# This trick comes from Camel 2 and approximates the 'switch'
# feature of C.
for (param('action')) {
   $_ eq 'view' and do { &view; last; };
   $_ eq 'add' and do { &add; last; };
   $_ eq 'add2' and do { &add2; last; };
   $_ eq 'add3' and do { &add3; last; };
   $_ eq 'add4' and do { &add4; last; };
   $_ eq 'schange' and do { &schange; last; };
   $_ eq 'schange2' and do { &schange2; last; };
   $_ eq 'lchange' and do { &lchange; last; };
   $_ eq 'lchange2' and do { &lchange2; last; };
   $_ eq 'lchange3' and do { &lchange3; last; };
   $_ eq 'delete' and do { &delete; last; };
   &default;
}



###
# Default Page
#
# This is the default function. It prints an index page allowing the user
# to chose which function they wish to use.
###
sub default {
   print header, start_html('title'=>'Subjects','BGCOLOR'=>'white');
   print <<HTML;
<h1>Subjects</h1>
<p>Select an action and a subject (if applicable).
<FORM ACTION="subject.cgi" METHOD=POST>
<p><SELECT NAME="action">
<OPTION VALUE="view">View a Subject
<OPTION value="add">Add a Subject
<OPTION value="schange">Modify a Subject
<OPTION value="lchange" SELECTED>Modify a Class List
<OPTION value="delete">Delete a Subject
</select> 
HTML
   # See 'sub print_subjects' below.
   &print_subjects;
   print <<HTML;
<p>
<INPUT TYPE=SUBMIT VALUE=" Perform Action "> 
<INPUT TYPE=RESET>
</form></body></html>
HTML

}

###
# View
#
# This function prints the details of a subject.
###
sub view {
   if (not param('subject')) { 
      # See 'sub error_subject_required' below.
      &error_subject_required('Please choose a subject to view:',
         'view');
   } else {
      if (not param('subject')) { 
         &end("You must choose a subject.");
      }
      my $id = param('subject');
      # We now select all of the information for the requested
      # subject.
      my $out = $dbh->query("select * from subjects where id=$id");
      # Since each ID is unique, we only need to call Msql::fetchrow()
      # once.
      my($did,$name,$teacher) = $out->fetchrow;
      print header, start_html('title'=>"$name", 'BGCOLOR'=>'white');
      print <<HTML;
<H1 align=center>$name</h1>
<p>
<b>Teacher</b>: $teacher
<p>
<UL>
HTML
      # Now we select the information from the 'students' table
      # about all of the students who are enrolled in this class.
      # The 'ext' field is a name extension, such as Jr., Sr., III, 
      # etc.
      my $out2 = $dbh->query("select id, first, middle, last, ext
         from students where subjects like '%:$id:%'");
      # Since we know the names of all the fields, we are retrieving
      # it is more efficient to use Msql::fetchhash() rather than
      # Msql::fetchrow(). Msql::fetchhash() places the results into
      # an associative array where the keys are the names of the 
      # fields and the values are the values.
      while (my(%fields)=$out2->fetchhash) {
         print qq%<LI>
<A HREF="students.cgi?action=view&id=$fields{'id'}">$fields{'first'} 
$fields{'middle'} $fields{'last'}%;
         if ($fields{'ext'}) {
            print ",$fields{'ext'}";
         }
         print "</a>\n";
      }
   print <<HTML;
</ul>
</body></html>
HTML
   }
}

###
# Add - Stage 1
#
# This is the first add function. Here the user can enter the basic 
# information about the class.
###
sub add {
   my (%fields);
   foreach ('name','size','teacher') {
      if (param($_)) { $fields{$_} = param($_); }
      else { $fields{$_} = ""; }
   }

   print header, start_html('title'=>'Add a Subject','BGCOLOR'=>'white');
   print <<HTML;
<H1>Add a Subject</h1>
<form METHOD=POST ACTION="subject.cgi">
<p>
Subject Name: <input size=40 name="name" value="$fields{'name'}"><br>
Teacher's Name: 
<input size=40 name="teacher" value="$fields{'teacher'}"><br>
Number of Students in Class: 
<input size=5 name="size" value="$fields{'size'}">
<p>
<INPUT TYPE=HIDDEN NAME="action" VALUE="add2">
<INPUT TYPE=SUBMIT VALUE=" Next Page "> 
<INPUT TYPE=RESET>
</form>
<p>
<A HREF="subject.cgi">Go</a> back to the main Subject page.<br>
<A HREF=".">Go</a> to the Teacher's Aide Home Page.
</body></html>
HTML

}

###
# Add - Stage 2
#
# This is the second stage of the add process. Here, the information from # the first stage is added to the database. Then, a form is printed 
# allowing the user to add the information for the number of students
# they said were in the class.
###
sub add2 {
   my ($i);
   my $teacher = "";
   my $enc_teacher = "";
   my $size = 0;
   if (not param('name')) 
      { &end("You must include a name."); }
   my $name = param('name');
   # We need one copy of the name that is encoded for the URL.
   my $enc_name = &cgi_encode($name);
   # We also need a copy of the name that is quoted safely for insertion
   # into the database. Msql provides the Msql::quote() function for that
   # purpose.
   my $query_name = $dbh->quote($name);

   # We now build a query to see if the subject entered already exists.
   my $query = 
      "select id, name, teacher from subjects where name=$query_name";

   # If the user supplied a teacher's name, we check for that teacher
   # specifically, since there can be two courses with the same name but
   # different teachers.
   if (param('teacher')) {
      $teacher = param('teacher');
      $enc_teacher = &cgi_encode($teacher);
      my $query_teacher = $dbh->quote($teacher);
      $query .= " and teacher=$query_teacher";
   }

   if (param('size')) {
      $size = param('size');
   }

   # Now we send the query to the mSQL server.
   my $out = $dbh->query($query);
   # We check $out->numrows to see if any rows were returned. If there
   # were any, and the user didn't supply an 'override' parameter, then
   # we exit with a message that the class already exists, and giving the
   # user a change to enter the class anyway (by resubmitting the form
   # with the 'override' parameter set. 
   if ($out->numrows and not param('override')) {
      print header, start_html('title'=>'Class Already Exists',
         'BGCOLOR'=>'white');
      print <<HTML;
<H1>Class Already Exists</h1>
<P>
A class with the same name and teacher is already in the database.
If this is a mistake, 
<A HREF="subject.cgi?action=add&enc_name=$name&teacher=$enc_teacher&size=$size">
Go</a> back and change the name.
<P>
Otherwise you can 
<A HREF=
"subject.cgi?action=add2&name=$enc_name&teacher=$enc_teacher&size=$size
&override=1"> # The URL should be all on one line.
add</a> the subject.
HTML
   } else {
      # Now we enter the information into the database.
      # First, we need to select the next number from the
      # table's sequence.
      $out = $dbh->query("select _seq from subjects");
      my ($id) = $out->fetchrow;

      # Then we insert the information into the database, using
      # the sequence number we just obtained as the ID.
      $query = "INSERT INTO subjects (id, name, teacher) 
         VALUES ($id, '$name', '$teacher')";
      $dbh->query($query);

      # If the user did not specify a class size, we exit with
      # a message letting the user know that he or she can add
      # students later.
      if (not param('size')) {
         print header, start_html('title'=>'Subject Added',
            'BGCOLOR'=>'white');
         print <<HTML;
<h1>Subject Added</h1>
<b>$name</b> has been added to the database.
<p>
You did not specify any number of students. You can add a class list 
<A HREF="subject.cgi?action=lchange&id=$id">now</a> if you wish, or at
any time in the future via the <A HREF="subject.cgi">main Subject page</a>.
<p>
<A HREF="subject.cgi?action=add">Add</a> another subject.<br>
<A HREF="subject.cgi">Go</a> to the main Subject page.<br>
<A HREF=".">Go</a> to the Teacher's Aide home page.
</body></html>
HTML
      } else {
         # Now we print a form, allowing the user to enter the
         # names of each of the students in the class.
         print header, start_html('title'=>'Create Class List',
            'BGCOLOR'=>'white');
         print <<HTML;
<H1>Create Class List</h1>
<P>
<B>$name</b> has been added to the database. You can
now enter the names of the students in the class. 
You may add or drop students later from the <a href="subject.cgi">main
Subject page</a>.
<p>
<FORM METHOD=POST ACTION="subject.cgi">
<INPUT TYPE=HIDDEN NAME="action" VALUE="add3">
<INPUT TYPE=HIDDEN NAME="id" VALUE="$id">
<TABLE BORDER=0>
<TR><TH><TH>
First Name<TH>Middle Name/Initial<TH>Last Name<TH>Jr.,Sr.,III,etc
</tr>
HTML
         for $i (1..$size) {
            print <<HTML;
<TR><TD>$i<TD>
<INPUT SIZE=15 NAME="first$i"><TD><INPUT SIZE=15 NAME="middle$i">
   <TD><INPUT SIZE=15 NAME="last$i"><TD><INPUT SIZE=5 NAME="ext$i"></tr>
HTML
         }
         print <<HTML;
</table>
<INPUT TYPE=SUBMIT VALUE=" Submit Class List ">
<INPUT TYPE=RESET>
</form></body></html>
HTML
      }
   }
}

###
# Add - Stage 3
#
# This is the third stage of adding a new subject. Here we check to see
# if the students provided already exist. If any of them don't exist, we
# print a page asking if this is an error. If all of them already exist,
# we add the subject to their class list and exit.
###
sub add3 {
   if (not param('id')) { &end("An ID number is required"); }
   my $id = param('id');

   # See 'sub find_last_student'. This returns a list of the students
   # entered by the user.
   my @list = &find_last_student;
   # See 'sub find_matching_students'. This returns a reference to
   # an array containing information about the students that already
   # exist, and a reference to an array containing information about
   # the students that don't exist.
   my ($ref_students,$ref_notstudents) = &find_matching_students(@list);

   # Put the references into real arrays. Each element of the arrays are
   # references to another array containing the information for that
   # student. So $students[0] is a reference to an array containing the
   # following fields ( 'id', 'subjects', 'first name', 'middle name',
   # 'last name', 'extension'). Likewise, $notstudents[0] is a reference
   # to an array containing ( 'first name', 'middle name', 'last name',
   # 'extension').
   my @students = ();
   my @notstudents = ();
   @students = @$ref_students if $ref_students;
   @notstudents = @$ref_notstudents if $ref_notstudents;

   # If any students don't exist, exit with a page that lets the user
   # go back to fix any typos, or go forward to enter all of the students
   # into the database. The rest of the student details can then be filled
   # in via student.cgi.
   if (@notstudents) {
      print header, start_html('title'=>'Non-Existant Students Found',
         'BGCOLOR'=>'white');
      print <<HTML;
<H1>Non-Existant Students Found</h1>
At least one of the students entered does not exist in the database:
<P>
<FORM ACTION="subject.cgi" METHOD=POST>
<INPUT TYPE=HIDDEN NAME="action" VALUE="add4">
<INPUT TYPE=HIDDEN NAME="id" VALUE="$id">
HTML
      # See 'sub print_students'. This returns the number of the
      # last student in the array.
      my $num = &print_students(@students);
      # See 'sub print_notstudents'.
      &print_notstudents($num, @notstudents);

      print <<HTML;
<p>
If any of these are a mistake, go back to the previous page and re-submit
the form.  Otherwise, choose 'finish' to automatically enter these
students into the database.  You can then use the <A
HREF="student.cgi?action=change">Student Change Form</a> to fill in the
details for the student. 
<p>
<INPUT TYPE=SUBMIT VALUE=" Finish ">
 <INPUT TYPE=RESET>
</form></body></html>
HTML
   } else {
      # At this point, there are no non-existent students, so
      # we can just update the students.
      # See 'sub update_students'.
      &update_students($id,@students);
      print header, start_html('title'=>'Class List Added',
         'BGCOLOR'=>'white');
      print <<HTML;
<H1>Class List Added</h1>
<P>
The subject and class list have been added to the database.
<P>
<A HREF=".">Go</a> to the Teacher's Aide home page.<br>
<A HREF="subject.cgi">Go</a> to the main Subjects page.<br>
<A HREF="subject.cgi?action=add">Add</a> another Subject.<br>
</body></html>
HTML
   }
}

###
# Add - Stage 4
#
# This is the fourth stage of adding a new subject. This is only reached
# if the user asked to add new students to the database. Here we add the
# students to the database and then exit with a success message.
###
sub add4 {
   if (not param('id')) { &end("An ID number is required"); }
   my $id = param('id');

   my @list = &find_last_student;
   my ($ref_students,$ref_notstudents) = &find_matching_students(@list);
   my @students = ();
   my @notstudents = ();
   @students = @$ref_students if $ref_students;
   @notstudents = @$ref_notstudents if $ref_notstudents;

   # We now update the already existing students, and insert the
   # non-existing ones. See 'sub update_students' and 
   # 'sub insert_students'.
   &update_students($id,@students) if @students;
   &insert_students($id,@notstudents) if @notstudents;

   print header, start_html('title'=>'Class List Added', 
      'BGCOLOR'=>'white');
   print <<HTML;
<H1>Class List Added</h1>
<P>
The subject, class list and students have been added to the database.
<P>
<A HREF=".">Go</a> to the Teacher's Aide home page.<br>
<A HREF="subject.cgi">Go</a> to the main Subjects page.<br>
<A HREF="subject.cgi?action=add">Add</a> another Subject.<br>
</body></html>
HTML
}

###
# Change Subject - Stage 1
#
# This is the first stage of the 'Change Subject' process. Here a user
# can change the non-student related information about the class, such as
# its name and the teacher's name.
###
sub schange {
   if (not param('subject')) {
      &error_subject_required('Please choose a subject to modify:',
         'schange');
   } else {
      # First, we retrieve all of the information about the selected
      # subject from the database.
      my $id = param('subject');
      my $out = $dbh->query("select * from subjects where id=$id");

      # We know what the database fields are ('name', 'teacher',
      # 'size'), so we can use Msql::fetchhash(). We only need to
      # call this once since we know that each subject id is unique.
      my %fields = $out->fetchhash;
      print header;
      print <<HTML;
<HTML><HEAD><TITLE>Change Subject</title></head>
<BODY BGCOLOR="#FFFFFF">
<h1>Changing $fields{'name'}</h1>
To change class list information, go to the 
<A HREF="subject.cgi?action=lchange">Class list change page</a>.
<p>
<FORM ACTION="subject.cgi" METHOD=POST>
<INPUT TYPE=HIDDEN NAME="action" VALUE="schange2">
<INPUT TYPE=HIDDEN NAME="id" VALUE="$id">
Name: <INPUT SIZE=40 NAME="name" VALUE="$fields{'name'}"><br>
Teacher: <INPUT SIZE=40 NAME="teacher" VALUE="$fields{'teacher'}">
<p>
<INPUT TYPE=SUBMIT VALUE=" Change Subject ">
 <INPUT TYPE=SUBMIT NAME="delete" VALUE=" DELETE SUBJECT ">
 <INPUT TYPE=RESET>
</form></body></html>
HTML
   }
}

###
# Change Subject - Stage 2
#
# This processes the information from 'Change Subject' stage 1.
###
sub schange2 {
   if (not param('id')) { &end("An ID number is required."); }
   my $id = param('id');
   # If the user chose 'Delete' we can skip straight to the delete()
   # function. See 'sub delete'.
   if (param('delete')) {
      &delete($id);
   } else {
      my ($name, $teacher) = ( param('name'), param('teacher') );
      $name =~ s/'/\\'/g;
      $teacher =~ s/'/\\'/g;
      # Send the UPDATE query to the database.
      my $query = 
   "update subjects set name='$name', teacher='$teacher' where id=$id";
      $dbh->query($query);
      print header, start_html('title'=>'Subject Changed',
         'BGCOLOR'=>'white');
      print <<HTML;
<H1>Subject Changed</h1>
<p>
The information for the requested subject has been changed.
<p>
<A HREF=".">Go</a> to the Teacher's Aide home page.<br>
<A HREF="subject.cgi">Go</a> to the main Subjects page.
</body></html>
HTML
   }
}

###
# Change Class List - Stage 1
#
# This is the first stage of the 'Change Class List' feature. This allows
# users to add or remove students to the class list.
###
sub lchange {
   if (not param('subject')) {
      &error_subject_required(
         'Please choose a subject to modify the class list:',
         'lchange');
   } else {
      my $id = param('subject');
      # We need to know the actual name of the subject so we can
      # use it in the HTML pages.
      my $out1 = $dbh->query("select name from subjects where 
         id=$id");
      my ($name) = $out1->fetchrow;

      # Now we select the information about the students who are
      # enrolled in the selected class.
      my $out = $dbh->query("select id, first, middle, last, ext
         from students where subjects like '%:$id:%'");
      # $out->numrow tells us how many students matched the query.
      my $matches = $out->numrows;

      # Now we print the HTML page. We print out all of the students
      # currently in the class, as well as five spaces for new
      # students.
      print header, start_html('title'=>'Modify a Class list',
         'BGCOLOR'=>'white');
      print <<HTML;
<H1>Modify a Class List for $name</h1>
There are $matches students currently enrolled in this class.
You may remove any of these students or add new students below.
<p>
<FORM METHOD=POST ACTION="subject.cgi">
<INPUT TYPE=HIDDEN NAME="action" VALUE="lchange2">
<INPUT TYPE=HIDDEN NAME="id" VALUE="$id">
<TABLE BORDER=0>
<TR><TH align=left>Drop?<TH align=left>First<TH align=left>Middle
<TH align=left>Last<TH align=left>Jr.,III,etc.</tr>
HTML
      # Go through all of the returned students.
      while(my(%fields)=$out->fetchhash) {
         print qq%<TR><TD>
 <INPUT TYPE=CHECKBOX NAME="drop$fields{'id'}" VALUE="yes">
 <TD>$fields{'first'} <TD>$fields{'middle'} <TD>$fields{'last'}
 <TD>$fields{'ext'}</tr>\n%;
   }
      # Print five spaces for new students.
      for (1..5) {
         print qq%<TR><TD><TD><INPUT NAME="first$_" SIZE=15>
<TD><INPUT NAME="middle$_" SIZE=15><TD><INPUT NAME="last$_" SIZE=15>
<TD><INPUT NAME="ext$_" SIZE=5></tr>\n%;
      }
      print <<HTML;
</table>
<p>
<INPUT TYPE=SUBMIT VALUE=" Make Changes "> 
 <INPUT TYPE=SUBMIT NAME="more" VALUE=" Add More Students ">
 <INPUT TYPE=RESET>
</form><body></html>
HTML
   }
}

###
# Change Class List - Stage 2
#
# This processes the information from stage 1. Here, the students
# selected to drop the class are dropped. In addition, new students are
# processes as in Add Stage three (see 'sub add3').
###
sub lchange2 {
   my ($id);
   my $more = 0;
   if (@_) { $id = shift; $more = shift; } 
   elsif (not param('id')) { &end("An ID number is required."); }
   else { 
      $id = param('id'); 
      $more = 1 if param('more');
   }

   # Check to see if any of the parameters begin with 'drop', if so
   # the user wants to drop that student.
   foreach (param) {
      if (/^drop(\d+)$/) {
         my $sid = $1;
         # Get the current subjects for that student.
         my $out = $dbh->query("select subjects from students 
            where id=$sid");
         my ($subjects) = $out->fetchrow;
         # Remove the selected subject.
         $subjects =~ s/:$id:/:/;
         # Change the subjects for the student.
         $dbh->query("update students set subjects='$subjects' 
            where id=$sid");
      }
   }

   # The rest of this section is almost identical to add3().

   my @list = &find_last_student;
   my ($ref_students,$ref_notstudents) = &find_matching_students(@list);
   my @students = ();
   my @notstudents = ();
   @students = @$ref_students if $ref_students;
   @notstudents = @$ref_notstudents if $ref_notstudents;

   if (@notstudents) {
      print header, start_html('title'=>'Non-Existant Students Found',
         'BGCOLOR'=>'white');
      print <<HTML;
<H1>Non-Existant Students Found</h1>
At least one of the students entered does not exist in the database:
<P>
<FORM ACTION="subject.cgi" METHOD=POST>
<INPUT TYPE=HIDDEN NAME="action" VALUE="lchange3">
<INPUT TYPE=HIDDEN NAME="id" VALUE="$id">
HTML
      &print_notstudents(@notstudents);
      print <<HTML;
<P>
If any of these are a mistake, go back to the previous page and re-submit
the form.  Otherwise, choose 'finish' or 'add more students' to automatically enter these,
students into the database (and optionally add more).  You can then use the <A
HREF="student.cgi?action=change">Student Change Form</a> to fill in the
details for the student.
<P>
<INPUT TYPE=SUBMIT VALUE=" Finish "> <INPUT TYPE=SUBMIT NAME="more" 
VALUE=" Add More Students ">
 <INPUT TYPE=RESET>
</form></body></html>
HTML
   } else {
      &update_students($id,@students);
      if (not $more) {
         print header, start_html('title'=>'Class List Changed',
            'BGCOLOR'=>'white');
         print <<HTML;
<H1>Class List Changed</h1>
<P>
The class list has been changed.
<P>
<A HREF=".">Go</a> to the Teacher's Aide home page.<br>
<A HREF="subject.cgi">Go</a> to the main Subjects page.<br>
<A HREF="subject.cgi?action=lchange">Change</a> another class list.<br>
</body></html>
HTML
      } else { 
      # If the user select 'Add more students', another 5
      # slots are printed to add new students.
         print header, start_html('title'=>'Add More Students',
            'BGCOLOR'=>'white');
         print <<HTML;
<H1>Add More Students</h1>
<P>
<FORM METHOD=POST ACTION="subject.cgi">
<INPUT TYPE=HIDDEN NAME="action" VALUE="lchange2">
<INPUT TYPE=HIDDEN NAME="id" VALUE="$id">
<TABLE BORDER=0>
<TR><TH align=left>First<TH align=left>Middle
<TH align=left>Last<TH align=left>Jr.,III,etc.</tr>
HTML
         for (1..5) {
            print qq%<TR><TD><INPUT NAME="first$_" SIZE=15>
<TD><INPUT NAME="middle$_" SIZE=15><TD><INPUT NAME="last$_" SIZE=15>
<TD><INPUT NAME="ext$_" SIZE=5></tr>\n%;
         }
         print <<HTML;
</table>
<p>
<INPUT TYPE=SUBMIT VALUE=" Make Changes ">
 <INPUT TYPE=SUBMIT NAME="more" VALUE=" Add More Students ">
 <INPUT TYPE=RESET>
</form><body></html>
HTML
      }
   }
}

###
# Change Class List - Stage 3
#
# This is the third stage of changing the class list. This is only 
# reached if the user asked to add new students in the previous section. 
# This stage is very similar to Add Stage 4 (See 'sub add4').
###
sub lchange3 {
   my ($i);
   if (not param('id')) { &end("An ID number is required"); }
   my $id = param('id');

   my @list = &find_last_student;
   my ($ref_students,$ref_notstudents) = &find_matching_students(@list);
   my @students = ();
   my @notstudents = ();
   @students = @$ref_students if $ref_students;
   @notstudents = @$ref_notstudents if $ref_notstudents;

   &update_students($id,@students);
   &insert_students($id,@notstudents);

   # If the user asks to add more students, skip back to lchange2,
   # otherwise exit with a success message.
   if (param('more')) {
      &lchange2($id,1);
   } else {
      print header, start_html('title'=>'Students Added',
         'BGCOLOR'=>'white');
      print <<HTML;
<H1>Class List Added</h1>
<P>
The students have been added to the database.
<P>
<A HREF=".">Go</a> to the Teacher's Aide home page.<br>
<A HREF="subject.cgi">Go</a> to the main Subjects page.<br>
<A HREF="subject.cgi?action=lchange">Change</a> another Class List.<br>
</body></html>
HTML
   }
}

###
# Delete - Stage 1
#
# This is the first, and only, stage required to
# delete an entire subject.
###
sub delete {
   if (not param('subject') and not @_) {
      print header, start_html('title'=>'Subject Required',
         'BGCOLOR'=>'white');
      print <<HTML;
<H1>Subject Required</h1>
<P>
Please choose a subject to delete:<br>
<FORM ACTION="subject.cgi" METHOD=POST>
<INPUT TYPE=HIDDEN NAME="action" VALUE="delete"> 
HTML
      &print_subjects;
      print <<HTML;
<p> 
<INPUT TYPE=SUBMIT VALUE=" Next Page ">
 <INPUT TYPE=RESET>
</form></body></html>
HTML
   } else {
      my ($id);
      if (@_) { $id = shift; }
      else { $id = param('subject'); }
      # Get the name of the subject for use in the HTML page.
      my $out1 = 
         $dbh->query("select name from subjects where id=$id");
      my ($name) = $out1->fetchrow;

      # Delete the subject.
      $dbh->query("delete from subjects where id=$id");

      # Select all of the students who had that subject.
      my $out = $dbh->query("select id, subjects from students where 
         subjects like '%:$id:%'");
      # For each of them, remove the subject and then update their
      # record with the new subject list.
      while (my($sid,$subjects)=$out->fetchrow) {
         $subjects =~ s/:$id:/:/;
         $dbh->query("update students set subjects='$subjects' 
         where id=$sid");
      }
      print header, start_html('title'=>"$name Deleted",
         'BGCOLOR'=>'white');
      print <<HTML;
<H1>$name Deleted</h1>
<p>
The subject <b>$name</b> has been removed from the database and
all students have been disenrolled from the class.
<p>
<A HREF=".">Go</a> to the Teacher's Aide home page.<br>
<A HREF="subject.cgi">Go</a> to the main Subjects page.<br>
<A HREF="subject.cgi?action=delete">Delete</a> another subject.<br>
</body></html>
HTML
   }
}

# This is a helper function that prints out a SELECT list of all the
# subjects in the database.
sub print_subjects {
   print qq%<SELECT NAME="subject">\n%;
   my $out = $dbh->query("select * from subjects order by name");
   while(my(%keys)=$out->fetchhash) {
      print qq%<OPTION VALUE="$keys{'id'}">$keys{'name'}\n%;
   }
   print "</select>\n";
}

# This is a helper function that transforms a string into a copy which
# is safe to include in a URL.
sub cgi_encode {
   my $string = shift;
   $string =~ s/(\W)/"%" . sprintf("%02lx",ord($1))/ge;
   return $string;
}

# This is a helper function that hunts through all of the user supplied
# parameters looking for ones that correspond to a student name. It then
# creates a sorted list of the numbers from the form. This list will be
# from 1 to n where n is the number of students entered by the user. 
sub find_last_student {
   my @params = param;
   my @list = ();
   foreach (@params) {
      next if not param($_);
      if (/^(first|middle|last|ext)(\d+)/) { 
         my $num = $2;
         if (not grep(/^$num$/,@list)) { push(@list,$2); }
      }
   }
   @list = sort { $a <=> $b} @list;
   return @list;
}

# This is a helper function that looks through the list of students. It
# separates the students into two groups: those that already exist in the
# database and those that don't. For those that do, it returns a 
# reference to an array containing array references that hold the 
# following information: ( 'id', 'subjects', 'first name', 'middle name', 
# 'last name', 'extension' ). For those that don't exist it returns a 
# reference to an array containing array references that hold 
# ('first name', 'middle name', 'last name', 'extension').
sub find_matching_students {
   my @list = @_;
   my ($i,@students,@notstudents);
   @students = ();
   @notstudents = ();
   if (@list) {
      foreach $i (@list) {
         my @query = ();
         # Build a query that looks for a specific student.
         my $query = "select id, subjects from students where ";
         foreach ('first','middle','last','ext') {
            if (param("$_$i")) {
               my $temp = param("$_$i");
               $temp =~ s/'/\\'/g;
               push(@query,"$_ = '$temp'");
            }
         }
         $query .= join(" and ",@query);
   
         # Send the query to the database.
         my $out = $dbh->query($query);
         # If the database doesn't return anything, add the
         # student to the @notstudents array.
         if (not $out->numrows) {
            push(@notstudents,[ param("first$i"), 
               param("middle$i"),
               param("last$i"), param("ext$i") ]);
         # Otherwise add the student to the @students array.
         } else {
            my ($id,$subjects) = $out->fetchrow;
            push(@students,[$id,$subjects]);
         }
      }
   }
   return(\@students,\@notstudents);
}

# This is a helper function that prints an unordered list of the students
# that don't exist in the database. It also prints hidden form 
# information about these students.
sub print_notstudents {
   my @notstudents = @_;
   my $i = 1;
   print "<UL>\n";
   foreach (@notstudents) {
      my %student;
      ($student{'first'}, $student{'middle'},
         $student{'last'}, $student{'ext'}) = @$_;
print qq%<LI>$student{'first'} $student{'middle'} $student{'last'}%;
      if ($student{'ext'}) { print ", $student{'ext'}"; }
      print "\n";
      foreach ('first','middle','last','ext') {
print qq%<INPUT TYPE=HIDDEN NAME="$_$i" VALUE="$student{$_}">\n%;
      }
      $i++;
   }
   print "<\ul>\n";
}

# This is a helper function which prints hidden form information about
# the students that already exist in the database.
sub print_students {
   my @students = @_;
   my $i = 1;
   my($id,$subjects);
   foreach (@students) {
      my %student;
      ($id,$subjects,$student{'first'}, $student{'middle'},
         $student{'last'}, $student{'ext'}) = @$_;
      print "\n";
      foreach ('first','middle','last','ext') {
print qq%<INPUT TYPE=HIDDEN NAME="$_$i" VALUE="$student{$_}">\n%;
      }
      $i++;
   }
   print "<\ul>\n";
   $i = 1 if not $i;
   return $i;
}

# This is a helper function that adds the given subject to the subjects
# list of the given students.
sub update_students {
   my $id = shift;
   my @students = @_;
   foreach (@students) {
      my($sid,$subjects)=@$_;
      if (not $subjects) { $subjects = ":$id:"; }
      elsif ($subjects !~ /:$id:/) { $subjects .= "$id:"; }
      my $query = "update students set subjects='$subjects'
         where id=$id";
      $dbh->query($query);
   }
}

# This is a helper function that add the given students to the students
# database. Only the name information is added. The rest can be added 
# later via student.cgi.
sub insert_students {
   my ($i);
   my $id = shift;
   my @list = @_;
   foreach $i (@list) {
      # This selects the next number in the sequence defined on the
      # table. We then use this number as the ID of the student.
      my $out = $dbh->query('select _seq from students');
      my($sid) = $out->fetchrow;

      # We have to quote all of the text strings for inclusion
      # in the database.
      my ($first, $middle, $last, $ext) = ( 
         $dbh->quote(param("first$i")),
         $dbh->quote(param("middle$i")), 
         $dbh->quote(param("last$i")), 
         $dbh->quote(param("ext$i"))
      );
      my $query = "insert into students (id, first, middle, last, 
         ext, subjects) VALUES ($sid, $first, $middle, 
         $last, $ext, ':$id:')";
      $dbh->query($query);
   }
}

# This is a helper function which prints out an error page letting the 
# user know that he or she left out a required parameter. This is similar 
# to the end() function from the my_end.pl library.
sub error_subject_required {
   my $message = shift;
   my $action = shift;
   print header, start_html('title'=>'Subject Required', 
      'BGCOLOR'=>'white');
   print <<HTML;
<H1>Subject Required</h1>
<P>$message<br>
<FORM ACTION="subject.cgi" METHOD=POST>
<INPUT TYPE=HIDDEN NAME="action" VALUE="$action">
HTML
   &print_subjects;
   print <<HTML;
<p>
<INPUT TYPE=SUBMIT VALUE=" Next Page ">
 <INPUT TYPE=RESET>
</form></body></html>
HTML

}

