﻿var webdriverjs = require("webdriverjs");
var browser = webdriverjs.remote({
    host: 'localhost',
    port: 4444,
    desiredCapabilities: {
        browserName: 'chrome',
        seleniumProtocol: 'WebDriver',
        'chrome.switches': [
            '--remote-debugging-port=9222',
            '--user-data-dir=remote-profile'
        ]
    }
});

browser.addCommand("startCapture", startCapture);

browser
    .init()
    .url('http://search.yahoo.com')
    .startCapture()
    .setValue("#yschsp", "JavaScript")
    .submitForm("#sf")
    .saveScreenshot('results.png')
    .end();

function startCapture(ready) {
    var http = require('http');
    var options = {
        host: 'localhost',
        port: 9222,
        path: '/json'
    };

    http.get(options, function(res) {
        res.on('data', function (chunk) {
            var resObj = JSON.parse(chunk);
            connectToDebugger(resObj[0], ready);
        });
    }).on('error', function(e) {
        console.log("エラー発生: " + e.message);
    });
}

function connectToDebugger(obj, ready) {
    var fs = require('fs');
    var WebSocket = require('faye-websocket');
    var ws = new WebSocket.Client(obj.webSocketDebuggerUrl);
    var msg = {
        id: 777,
        method: "Timeline.start",
        params: {
            maxCallStackDepth: 10
        }
    };
    var messages = '';

    ws.onopen = function(event) {
        ws.send(JSON.stringify(msg));
        ready();
    };

    ws.onmessage = function(event) {
        var obj = JSON.parse(event.data);
        if (obj.method && obj.method === 'Timeline.eventRecorded') {
            obj.record = obj.params.record; // ちょっとしたハック
            messages += JSON.stringify(obj) + '\n';
        }
    };

    ws.onclose = function(event) {
        var header = '<html isdump="true">\n<body><span id="info">'
            + '</span>\n<div id="traceData" isRaw="true" version="0.26">';
        var footer = '</div></body></html>';

        ws = null;
        fs.writeFileSync('DUMP.speedtracer.html', header + messages
            + footer, 'utf8');
    };
}
